package immibis.ccperiphs.speaker;

import immibis.ccperiphs.RenderUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.ForgeHooksClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderTileSpeaker extends TileEntitySpecialRenderer {
	
	@Override
	public void renderTileEntityAt(TileEntity var1, double x, double y, double z, float var8) {
		ForgeHooksClient.bindTexture("/immibis/ccperiphs/world.png", 0);
		TileSpeaker ts = (TileSpeaker)var1;
		immibis.core.RenderUtils.setBrightness(var1.worldObj, var1.xCoord, var1.yCoord, var1.zCoord);
		if(ts.client != null)
			RenderUtils.renderSpeakerDynamic((float)x, (float)y, (float)z, ts.facing, (float)ts.client.r_amplitude, ts.client.r_phase, var8, ts.client);
		else
			ts.client = ClientSpeaker.get(var1.xCoord, var1.yCoord, var1.zCoord, var1.worldObj.provider.dimensionId);
		ForgeHooksClient.unbindTexture();
	}
}