package immibis.ccperiphs;

import immibis.ccperiphs.lan.TileNIC;
import immibis.ccperiphs.rfid.TileMagStripe;
import immibis.ccperiphs.rfid.TileRFIDReader;
import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.ccperiphs.speaker.TileSpeaker;
import immibis.ccperiphs.tape.TileTapeDrive;
//import immibis.ccperiphs.smartcard.TileSCInterface;

import java.lang.reflect.InvocationTargetException;

public enum EnumPeriphs {
	RFID_WRITER("RFID writer", TileRFIDWriter.class),
	RFID_READER("RFID reader", TileRFIDReader.class),
	MAG_STRIPE("Mag-card reader", TileMagStripe.class),
	SPEAKER("Speaker", TileSpeaker.class),
	NIC("LAN modem", TileNIC.class),
	//TAPE_DRIVE("Tape drive", TileTapeDrive.class),
	//SC_WRITER("Smartcard reader", TileSCInterface.class),
	;
	
	private EnumPeriphs(String name, Class<? extends TilePeriphs> teclass) {
		this.name = name;
		this.teclass = teclass;
	}
	
	public final String name;
	public final Class<? extends TilePeriphs> teclass;
	
	public TilePeriphs createTile() {
		try {
			return teclass.getConstructor().newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new RuntimeException(e);
		} catch (NoSuchMethodException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
	
	public static final EnumPeriphs[] VALUES = values(); 
}
