package immibis.ccperiphs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import dan200.ComputerCraft;

import net.minecraft.src.*;
import net.minecraftforge.common.*;
import immibis.ccperiphs.lan.BlockLANWire;
import immibis.ccperiphs.lan.EnumWireTypes;
import immibis.ccperiphs.lan.ItemLANWire;
import immibis.ccperiphs.lan.TileNIC;
import immibis.ccperiphs.rfid.*;
import immibis.ccperiphs.speaker.ClientSpeaker;
import immibis.ccperiphs.speaker.PacketSpeakerStart;
import immibis.ccperiphs.speaker.PacketSpeakerStop;
import immibis.ccperiphs.speaker.PacketSpeakerStream;
import immibis.ccperiphs.speaker.TileSpeaker;
import immibis.ccperiphs.tape.ItemTape;
import immibis.core.Colour;
//import immibis.ccperiphs.smartcard.TileSCInterface;
import immibis.core.Config;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;

@Mod(name = "Immibis's Peripherals", modid = "ImmibisPeripherals", dependencies = "required-after:ImmibisCore", version="51.1.1", useMetadata=true)
@NetworkMod(serverSideRequired = false, clientSideRequired = true)
public class ImmibisPeripherals extends PortableBaseMod implements IPacketMap {
	
	public static BlockPeriphs block;
	public static BlockLANWire lanWire;
	public static ItemCardBase itemRFID, itemMagStripe, itemSmartCard;
	public static ItemTape itemTape;
	public static ImmibisPeripherals instance;
	public static File scBaseDir;
	
	public static final int GUI_RFID_WRITER = 0;
	
	public static boolean enableLANRegistration = true;
	
	public static int maxTapeSizeKB = 65536;
	
	public static final int PKT_SPEAKER_STOP = 1;
	public static final int PKT_SPEAKER_START = 2;
	public static final int PKT_SPEAKER_STREAM = 3;
	
	public static String adminPassword;
	public static boolean enableSendFrom;
	
	public ImmibisPeripherals() {
		instance = this;
	}
	
	public static final String CHANNEL = "ImmPhs"; // fairly short, since speakers can send lots of packets. TODO: use packet 131

	@SuppressWarnings("unchecked")
	@Init
	public void load(FMLInitializationEvent evt) {
		IDAllocator.RegisterBlockID("peripherals.block", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockPeriphs(id);
				ModLoader.registerBlock(block, ItemPeriphs.class);
			}
		});
		
		enableLANRegistration = Config.getBoolean("peripherals.enableLAN", true);
		enableSendFrom = Config.getBoolean("peripherals.enableLANSenderSpoofing", true);
		
		if(enableLANRegistration) {
			IDAllocator.RegisterBlockID("peripherals.lan-wire", new IBlockIDCallback() {
				@Override
				public void registerBlock(int id) {
					lanWire = new BlockLANWire(id);
					ModLoader.registerBlock(lanWire, ItemLANWire.class);
				}
			});
		}
		
		BlockPeriphs.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ccperiphs.BlockRenderer", true);
		
		adminPassword = Config.getString("peripherals.adminPassword", "", Configuration.CATEGORY_GENERAL, "");
		
		if(adminPassword.isEmpty())
			adminPassword = null;
		
		itemRFID = new ItemCardBase(Config.getItemID("peripherals.rfid", 7434) - 256, 48);
		itemMagStripe = new ItemCardBase(Config.getItemID("peripherals.magstripe", 7435) - 256, 64);
		//itemSmartCard = new ItemCardBase(Config.getItemID("peripherals.smartcard", 7436) - 256, 80);
		//itemTape = new ItemTape(Config.getItemID("peripherals.magtape", 7436) - 256, 128);
		
		ModLoader.addName(itemRFID, "RFID card");
		ModLoader.addName(itemMagStripe, "Mag-stripe card");
		//ModLoader.addName(itemSmartCard, "Smart card");
		//ModLoader.addName(itemTape, "Magnetic tape");
		
		CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemRFID.shiftedIndex));
		CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemMagStripe.shiftedIndex));
		//CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemTape.shiftedIndex));
		
		SidedProxy.instance.registerTileEntity(TileRFIDWriter.class, "immibis.cc-rfid.writer", "immibis.ccperiphs.rfid.RenderTileRFIDWriter");
		
		ModLoader.registerTileEntity(TileRFIDReader.class, "immibis.cc-rfid.reader");
		ModLoader.registerTileEntity(TileMagStripe.class, "immibis.cc-rfid.msreader");
		SidedProxy.instance.registerTileEntity(TileSpeaker.class, "immibis.cc-speaker", "immibis.ccperiphs.speaker.RenderTileSpeaker");
		//ModLoader.registerTileEntity(TileTapeDrive.class, "immibis.cc-tapedrive");
		ModLoader.registerTileEntity(TileNIC.class, "immibis.cc-lan.nic");
		
		//ModLoader.registerTileEntity(TileSCInterface.class, "immibis.cc-sc.writer");
		//scBaseDir = new File(mod_ComputerCraft.getBaseDir(), "mod-data/immibis-peripherals/smartcard");
		//createFakeBaseDir();
		
		OneTwoFiveNetworking.initReceiveClient(this, CHANNEL);
		
		enableClockTicks(false);
	}
	
	@PostInit
	public void postInit(FMLPostInitializationEvent evt) {
		if(ComputerCraft.ccTab != null) {
			block.setCreativeTab(ComputerCraft.ccTab);
			if(enableLANRegistration)
				lanWire.setCreativeTab(ComputerCraft.ccTab);
		}
	}
	
	@ClientOnly
	@Override
	public boolean onTickInGame() {
		ClientSpeaker.tickSystem();
		
		return true;
	}
	
	@SuppressWarnings("unused")
	private void createFakeBaseDir() {
		copyResourceToFileIfDoesntExist("/immibis/ccperiphs/smartcard/bios.lua", new File(scBaseDir, "mods/ComputerCraft/lua/bios.lua"));
	}

	private void copyResourceToFileIfDoesntExist(String respath, File file) {
		//if(file.exists())
		//	return;
		File parent = file.getParentFile();
		if(!parent.exists() && !parent.mkdirs())
			throw new RuntimeException("Failed to create "+parent);
		
		try {
			InputStream in = ImmibisPeripherals.class.getResourceAsStream(respath);
			if(in == null)
				throw new RuntimeException("Failed to open resource "+respath);
			
			try {
				FileOutputStream out = new FileOutputStream(file);
				try {
					byte[] buf = new byte[102400];
					while(true) {
						int read = in.read(buf);
						if(read < 0)
							break;
						out.write(buf, 0, read);
					}
				} finally {
					out.close();
				}
			} finally {
				in.close();
			}
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

	@PostInit
	public void modsLoaded(FMLPostInitializationEvent evt) {
		if(Config.getBoolean("peripherals.enableCraftingRFIDCards", true)) {
			ModLoader.addRecipe(new ItemStack(itemRFID, 1, 0),
				"RRR",
				"PPP",
				"RRR",
				'P', Item.paper,
				'R', Item.redstone
			);
		}
		if(Config.getBoolean("peripherals.enableCraftingMagCards", true)) {
			ModLoader.addRecipe(new ItemStack(itemMagStripe, 1, 0),
				"PPP",
				"IRI",
				'P', Item.paper,
				'R', Item.redstone,
				'I', Item.ingotIron
			);
		}
		if(Config.getBoolean("peripherals.enableCraftingRFIDReader", true)) {
			ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_READER.ordinal()),
				" T ",
				"SIS",
				"SRS",
				'S', Block.stone,
				'T', Block.torchRedstoneActive,
				'R', Item.redstone,
				'I', Item.ingotIron
			);
		}
		if(Config.getBoolean("peripherals.enableCraftingRFIDWriter", true)) {
			ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_WRITER.ordinal()),
				"L-L",
				"# #",
				"SRS",
				'S', Block.stone,
				'R', Item.redstoneRepeater,
				'#', Block.blockGold,
				'-', Block.thinGlass,
				'L', Block.redstoneLampIdle
			);
		}
		if(Config.getBoolean("peripherals.enableCraftingMagCardDevice", true)) {
			ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.MAG_STRIPE.ordinal()),
				"STS",
				"SRS",
				"SSS",
				'S', Block.stone,
				'R', Item.redstone,
				'T', Block.torchRedstoneActive
			);
		}
		if(Config.getBoolean("peripherals.enableCraftingSpeaker", true)) {
			ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.SPEAKER.ordinal()),
				"S#S",
				"SNS",
				"SNS",
				'S', Block.stone,
				'N', Block.music,
				'#', Block.blockSteel
			);
		}
		if(enableLANRegistration && Config.getBoolean("peripherals.enableCraftingLANModem", true)) {
			ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.NIC.ordinal()),
				"SWS",
				"TWT",
				"SSS",
				'S', Block.stone,
				'T', Block.torchRedstoneActive,
				'W', new ItemStack(lanWire, 1, EnumWireTypes.NORMAL.ordinal())
			);
		}
		if(enableLANRegistration && Config.getBoolean("peripherals.enableCraftingLANWire", true)) {
			ModLoader.addRecipe(new ItemStack(lanWire, 16, EnumWireTypes.NORMAL.ordinal()),
				"WWW",
				"RRR",
				"WWW",
				'W', new ItemStack(Block.cloth, 1, Colour.BLUE.woolId()),
				'R', Item.redstone
			);
		}
	}

	@Override
	public IPacket createPacket(byte id) {
		switch(id) {
		case PKT_SPEAKER_START: return new PacketSpeakerStart();
		case PKT_SPEAKER_STOP: return new PacketSpeakerStop();
		case PKT_SPEAKER_STREAM: return new PacketSpeakerStream();
		}
		return null;
	}
}
