package immibis.ccperiphs.speaker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.src.EntityPlayer;
import immibis.ccperiphs.ImmibisPeripherals;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.IPacket;

public class PacketSpeakerStop implements IPacket {

	public int x;
	public int y;
	public int z;
	public int dimension;
	
	@Override
	public byte getID() {
		return ImmibisPeripherals.PKT_SPEAKER_STOP;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		x = in.readInt();
		y = in.readInt();
		z = in.readInt();
		dimension = in.readInt();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(x);
		out.writeInt(y);
		out.writeInt(z);
		out.writeInt(dimension);
	}

	@ClientOnly
	@Override
	public void onReceived(EntityPlayer source) {
		if(source != null)
			return; // can't receive on server
		
		ClientSpeaker.stop(x, y, z, dimension);
	}

}
