package immibis.ccperiphs.speaker;

import static org.lwjgl.opengl.GL11.*;

import immibis.ccperiphs.RenderUtils;
import immibis.core.api.Dir;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import net.minecraft.src.Item;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraftforge.client.ForgeHooksClient;

@ClientOnly
public class RenderTileSpeaker extends TileEntitySpecialRenderer {
	
	@Override
	public void renderTileEntityAt(TileEntity var1, double x, double y, double z, float var8) {
		ForgeHooksClient.bindTexture("/immibis/ccperiphs/world.png", 0);
		TileSpeaker ts = (TileSpeaker)var1;
		immibis.core.RenderUtils.setBrightness(var1.worldObj, var1.xCoord, var1.yCoord, var1.zCoord);
		if(ts.client != null)
			RenderUtils.renderSpeakerDynamic((float)x, (float)y, (float)z, ts.facing, (float)ts.client.r_amplitude, ts.client.r_phase, var8, ts.client);
		else
			ts.client = ClientSpeaker.get(var1.xCoord, var1.yCoord, var1.zCoord, var1.worldObj.provider.dimensionId);
		ForgeHooksClient.unbindTexture();
	}
}