package mods.immibis.lxp;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BucketItem extends Item {
	public BucketItem(int i) {
		super(i);
		
		setUnlocalizedName("immibis/lxp:bucket");
		
		setCreativeTab(CreativeTabs.tabMisc);
		LanguageRegistry.addName(this, "LXP bucket");
		setContainerItem(Item.bucketEmpty);
		setMaxStackSize(1);
	}
	
	
	
	// load some GUI icons here to get access to an IconRegister
	
	public static Icon mghost, bghost, tghost;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void updateIcons(IconRegister reg) {
		super.updateIcons(reg);
		
		mghost = reg.registerIcon("immibis/lxp:mghost");
		bghost = reg.registerIcon("immibis/lxp:bghost");
		tghost = reg.registerIcon("immibis/lxp:tghost");
	}
}
