package mffs;

import forge.ISpecialResistance;
import forge.ITextureProvider;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class BlockMachine extends BlockContainer implements ITextureProvider, ISpecialResistance
{
    private int blockid;

    public BlockMachine(int var1)
    {
        super(var1, Material.ORE);
        this.blockid = var1;
        this.c(3.0F);
        this.b(50.0F);
        this.a(i);
    }

    public int getBlockid()
    {
        return this.blockid;
    }

    public int getGui(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        switch (var1.getData(var2, var3, var4))
        {
            case 0:
                return 1;

            case 1:
                return 2;

            case 2:
                return 3;

            case 3:
                return 4;

            case 4:
                return 6;

            case 5:
                return 5;

            case 6:
            default:
                return -1;

            case 7:
                return 8;

            case 8:
                return 9;

            case 9:
                return 10;
        }
    }

    /**
     * Called upon block activation (left or right click on the block.). The three integers represent x,y,z of the
     * block.
     */
    public boolean interact(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        if (var5.U() != null && var5.U().id == Block.LEVER.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().id == mod_ModularForceFieldSystem.MFFSUpgrades.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().id == mod_ModularForceFieldSystem.MFFSMaschines.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().getItem() instanceof ItemMFD)
        {
            return false;
        }
        else if (var1.isStatic)
        {
            return true;
        }
        else
        {
            int var6 = this.getGui(var1, var2, var3, var4, var5);

            if (var6 < 0)
            {
                return false;
            }
            else
            {
                var5.openGui(mod_ModularForceFieldSystem.instance, var6, var1, var2, var3, var4);
                return true;
            }
        }
    }

    public TileEntityMaschines getBlockEntity()
    {
        return null;
    }

    /**
     * Called whenever the block is added into the world. Args: world, x, y, z
     */
    public void onPlace(World var1, int var2, int var3, int var4)
    {
        if (!var1.isStatic)
        {
            int var5 = var1.getData(var2, var3, var4);

            if (var5 == 0)
            {
                TileEntityGeneratorCore var6 = (TileEntityGeneratorCore)var1.getTileEntity(var2, var3, var4);
                var6.addtogrid();
            }

            if (var5 == 1)
            {
                TileEntityAreaProjektor var8 = (TileEntityAreaProjektor)var1.getTileEntity(var2, var3, var4);
                var8.addtogrid();
            }

            if (var5 == 2)
            {
                TileEntityDirectionalProjektor var7 = (TileEntityDirectionalProjektor)var1.getTileEntity(var2, var3, var4);
                var7.addtogrid();
            }

            if (var5 == 3)
            {
                TileEntityDeflectorProjektor var10 = (TileEntityDeflectorProjektor)var1.getTileEntity(var2, var3, var4);
                var10.addtogrid();
            }

            if (var5 == 4)
            {
                TileEntityTubeProjektor var9 = (TileEntityTubeProjektor)var1.getTileEntity(var2, var3, var4);
                var9.addtogrid();
            }

            if (var5 == 7)
            {
                TileEntityReaktorField var11 = (TileEntityReaktorField)var1.getTileEntity(var2, var3, var4);
                var11.addtogrid();
            }
        }
    }

    /**
     * Called whenever the block is removed.
     */
    public void remove(World var1, int var2, int var3, int var4)
    {
        if (!var1.isStatic)
        {
            int var5 = var1.getData(var2, var3, var4);

            if (var5 == 0)
            {
                TileEntityGeneratorCore var6 = (TileEntityGeneratorCore)var1.getTileEntity(var2, var3, var4);
                var6.removefromgrid();
            }

            if (var5 == 1)
            {
                TileEntityAreaProjektor var10 = (TileEntityAreaProjektor)var1.getTileEntity(var2, var3, var4);
                var10.destroyField();
                var10.removefromgrid();
            }

            if (var5 == 2)
            {
                TileEntityDirectionalProjektor var9 = (TileEntityDirectionalProjektor)var1.getTileEntity(var2, var3, var4);
                var9.destroyField();
                var9.removefromgrid();
            }

            if (var5 == 3)
            {
                TileEntityDeflectorProjektor var12 = (TileEntityDeflectorProjektor)var1.getTileEntity(var2, var3, var4);
                var12.destroyField();
                var12.removefromgrid();
            }

            if (var5 == 4)
            {
                TileEntityTubeProjektor var11 = (TileEntityTubeProjektor)var1.getTileEntity(var2, var3, var4);
                var11.destroyField();
                var11.removefromgrid();
            }

            if (var5 == 5)
            {
                TileEntityDirectionalExtender var14 = (TileEntityDirectionalExtender)var1.getTileEntity(var2, var3, var4);
                var14.destroyField();
            }

            if (var5 == 7)
            {
                TileEntityReaktorField var13 = (TileEntityReaktorField)var1.getTileEntity(var2, var3, var4);
                var13.destroyField();
                var13.removefromgrid();
            }

            if (var5 == 9)
            {
                TileEntityReaktorMonitor var16 = (TileEntityReaktorMonitor)var1.getTileEntity(var2, var3, var4);
                var16.removefromgrid();
            }

            TileEntity var15 = var1.getTileEntity(var2, var3, var4);

            if (var15 instanceof TileEntityProjektor)
            {
                ItemStack var7 = ((TileEntityProjektor)var15).getItem(0);

                if (var7 != null && var7.getItem() instanceof ItemFrequenzCard)
                {
                    EntityItem var8 = new EntityItem(var1, (double)((float)var2), (double)((float)var3), (double)((float)var4), new ItemStack(mod_ModularForceFieldSystem.MFFSitemcardempty, 1));
                    var1.addEntity(var8);
                }
            }

            var1.q(var2, var3, var4);
        }
    }

    /**
     * Called when the block is placed in the world.
     */
    public void postPlace(World var1, int var2, int var3, int var4, EntityLiving var5)
    {
        if (!var1.isStatic)
        {
            TileEntityMaschines var6 = (TileEntityMaschines)var1.getTileEntity(var2, var3, var4);
            int var7 = MathHelper.floor((double)(var5.yaw * 4.0F / 360.0F) + 0.5D) & 3;
            int var8 = Math.round(var5.pitch);

            if (var8 >= 65)
            {
                var6.setFacing((short)1);
            }
            else if (var8 <= -65)
            {
                var6.setFacing((short)0);
            }
            else if (var7 == 0)
            {
                var6.setFacing((short)2);
            }
            else if (var7 == 1)
            {
                var6.setFacing((short)5);
            }
            else if (var7 == 2)
            {
                var6.setFacing((short)3);
            }
            else if (var7 == 3)
            {
                var6.setFacing((short)4);
            }
        }
    }

    /**
     * Determines the damage on the item the block drops. Used in cloth and wood.
     */
    protected int getDropData(int var1)
    {
        return var1;
    }

    public TileEntityMaschines getBlockEntity(int var1)
    {
        switch (var1)
        {
            case 0:
                return new TileEntityGeneratorCore();

            case 1:
                return new TileEntityAreaProjektor();

            case 2:
                return new TileEntityDirectionalProjektor();

            case 3:
                return new TileEntityDeflectorProjektor();

            case 4:
                return new TileEntityTubeProjektor();

            case 5:
                return new TileEntityDirectionalExtender();

            case 6:
                return new TileEntityGeneratorEUInjector();

            case 7:
                return new TileEntityReaktorField();

            case 8:
                return new TileEntityReaktorCooler();

            case 9:
                return new TileEntityReaktorMonitor();

            default:
                return null;
        }
    }

    public String getTextureFile()
    {
        return "/mffs_grafik/machines.png";
    }

    public int idDropped(int var1, Random var2)
    {
        switch (var1)
        {
            default:
                return this.id;
        }
    }

    public static boolean isActive(IBlockAccess var0, int var1, int var2, int var3)
    {
        TileEntity var4 = var0.getTileEntity(var1, var2, var3);
        return var4 instanceof TileEntityMaschines ? ((TileEntityMaschines)var4).getActive() : false;
    }

    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);
        short var7 = var6 instanceof TileEntityMaschines ? ((TileEntityMaschines)var6).getFacing() : 0;
        int var8 = var1.getData(var2, var3, var4);
        return isActive(var1, var2, var3, var4) ? (var7 == var5 ? var8 * 16 + 7 : (var7 != 0 && var5 == 0 ? var8 * 16 + 7 + 1 : var8 * 16 + 7 + var5)) : (var7 == var5 ? var8 * 16 : (var7 != 0 && var5 == 0 ? var8 * 16 + 1 : var8 * 16 + var5));
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return var2 * 16 + var1 - 1;
    }

    public float getSpecialExplosionResistance(World var1, int var2, int var3, int var4, double var5, double var7, double var9, Entity var11)
    {
        if (var1.getTileEntity(var2, var3, var4) instanceof TileEntityMaschines)
        {
            TileEntity var12 = var1.getTileEntity(var2, var3, var4);
            return ((TileEntityMaschines)var12).getActive() ? 60000.0F : 50.0F;
        }
        else
        {
            return 50.0F;
        }
    }

    /**
     * Returns the TileEntity used by this block.
     */
    public TileEntity a_()
    {
        return this.getBlockEntity();
    }
}
