package mffs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public abstract class TileEntityProjektor extends TileEntityMaschines
{
    private ItemStack[] ProjektorItemStacks;
    private boolean camouflage;
    private boolean zapper;
    private boolean dropper;
    private boolean Subwater;
    private boolean Dome;
    private boolean hardner;
    private int Projektor_ID;
    private int linkGenerator_ID;
    private boolean linkGenerator;
    private int linkPower;
    private int maxlinkPower;
    private short ticker;
    private int fpcost;
    private boolean create;
    private int energy_ticker = 0;
    private short ffmeta;
    private int textur;
    protected StringBuffer hasher = new StringBuffer();
    protected Queue field_queue = new LinkedList();

    public void handleBaseUpdate(int[] var1)
    {
        this.linkPower = var1[3];
        this.maxlinkPower = var1[4];
    }

    public int[] getBaseUpdate()
    {
        return new int[] {(this.camouflage ? 1 : 0) + (this.zapper ? 2 : 0) + (this.dropper ? 4 : 0) + (this.Subwater ? 8 : 0) + (this.Dome ? 16 : 0) + (this.hardner ? 32 : 0) + (this.linkGenerator ? 64 : 0) + (this.create ? 128 : 0), this.Projektor_ID, this.linkGenerator_ID, this.linkPower, this.maxlinkPower, (this.ticker & 65535) + (this.ffmeta << 16), this.fpcost, this.energy_ticker, this.textur};
    }

    public TileEntityProjektor()
    {
        Random var1 = new Random();
        this.ProjektorItemStacks = new ItemStack[1];
        this.linkGenerator_ID = 0;
        this.Projektor_ID = var1.nextInt();
        this.linkGenerator = false;
        this.linkPower = 0;
        this.maxlinkPower = 1000000;
        this.ticker = 0;
        this.create = true;
        this.Subwater = false;
        this.Dome = false;
        this.hardner = false;
        this.dropper = true;
        this.zapper = false;
        this.camouflage = false;
        this.textur = -1;
        this.ffmeta = 0;
    }

    public boolean isCreate()
    {
        return this.create;
    }

    public void setCreate(boolean var1)
    {
        this.create = var1;
        ++this.baseUpdateCount;
    }

    public short getTicker()
    {
        return this.ticker;
    }

    public void setTicker(short var1)
    {
        this.ticker = var1;
        ++this.baseUpdateCount;
    }

    public int getTextur()
    {
        return this.textur;
    }

    public void setTextur(int var1)
    {
        this.textur = var1;
        ++this.baseUpdateCount;
    }

    public short getffmeta()
    {
        return this.ffmeta;
    }

    public void setffmeta(short var1)
    {
        this.ffmeta = var1;
        ++this.baseUpdateCount;
    }

    public int getMaxlinkPower()
    {
        return this.maxlinkPower;
    }

    public void setMaxlinkPower(int var1)
    {
        this.maxlinkPower = var1;
        ++this.baseUpdateCount;
    }

    public boolean isLinkGenerator()
    {
        return this.linkGenerator;
    }

    public void setLinkGenerator(boolean var1)
    {
        this.linkGenerator = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkPower()
    {
        return this.linkPower;
    }

    public void setLinkPower(int var1)
    {
        this.linkPower = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkGenerator_ID()
    {
        return this.linkGenerator_ID;
    }

    public void setLinkGenerator_ID(int var1)
    {
        this.linkGenerator_ID = var1;
        ++this.baseUpdateCount;
    }

    public boolean isCamouflage()
    {
        return this.camouflage;
    }

    public void setCamouflage(boolean var1)
    {
        this.camouflage = var1;
        ++this.baseUpdateCount;
    }

    public boolean isZapper()
    {
        return this.zapper;
    }

    public void setZapper(boolean var1)
    {
        this.zapper = var1;
        ++this.baseUpdateCount;
    }

    public boolean isSubwater()
    {
        return this.Subwater;
    }

    public void setSubwater(boolean var1)
    {
        this.Subwater = var1;
        ++this.baseUpdateCount;
    }

    public boolean isDome()
    {
        return this.Dome;
    }

    public void setDome(boolean var1)
    {
        this.Dome = var1;
        ++this.baseUpdateCount;
    }

    public boolean isDropper()
    {
        return this.dropper;
    }

    public void setDropper(boolean var1)
    {
        this.dropper = var1;
        ++this.baseUpdateCount;
    }

    public boolean isHardner()
    {
        return this.hardner;
    }

    public void setHardner(boolean var1)
    {
        this.hardner = var1;
        ++this.baseUpdateCount;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.Projektor_ID = var1.getInt("Projektor_ID");
        this.ffmeta = var1.getShort("ffmeta");
        this.textur = var1.getInt("textur");
        NBTTagList var2 = var1.getList("Items");
        this.ProjektorItemStacks = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.ProjektorItemStacks.length)
            {
                this.ProjektorItemStacks[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("Projektor_ID", this.Projektor_ID);
        var1.setShort("ffmeta", this.ffmeta);
        var1.setInt("textur", this.textur);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.ProjektorItemStacks.length; ++var3)
        {
            if (this.ProjektorItemStacks[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.ProjektorItemStacks[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    public int getProjektor_ID()
    {
        return this.Projektor_ID;
    }

    public void Hardnerdrop(int var1, int var2, int var3)
    {
        int var4 = this.world.getTypeId(var1, var2, var3);
        int var5 = this.world.getData(var1, var2, var3);

        if (var4 >= 122)
        {
            var4 = 0;
        }

        switch (var4)
        {
            case 1:
                var4 = 4;
                var5 = 0;
                break;

            case 2:
            case 60:
                var4 = 3;
                var5 = 0;
                break;

            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
            case 51:
            case 54:
            case 69:
            case 90:
                var4 = 0;
                break;

            case 26:
                var4 = 355;
                var5 = 0;
                break;

            case 55:
                var4 = 331;
                var5 = 0;
                break;

            case 63:
            case 68:
                var4 = 323;
                var5 = 0;
                break;

            case 83:
                var4 = 338;
                var5 = 0;
                break;

            case 93:
            case 94:
                var4 = 356;
                var5 = 0;
        }

        if (var4 != 0)
        {
            if (this.dropper)
            {
                ItemStack var6 = new ItemStack(var4, 1, var5);
                EntityItem var7 = new EntityItem(this.world, (double)var1, (double)var2, (double)var3, var6);
                this.world.addEntity(var7);
            }

            this.world.setTypeId(var1, var2, var3, 0);
        }
    }

    public void FieldGenerate(boolean var1)
    {
        int var2 = 0;
        short var3 = 1000;
        Iterator var4;
        String var5;
        ForceFieldWorldMap var6;

        if (var1 || this.energy_ticker == 20)
        {
            var4 = this.field_queue.iterator();

            while (var4.hasNext())
            {
                var5 = (String)var4.next();
                var6 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var5.toString());

                if (var6.ffworld_getfirstfreespace())
                {
                    TileEntity var7 = (TileEntity)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(var6.ffworld_getfirstGenerator_ID()));

                    if (var7 instanceof TileEntityGeneratorCore && var7 != null)
                    {
                        boolean var8 = false;
                        int var9;

                        if (var1)
                        {
                            var9 = mod_ModularForceFieldSystem.forcefieldblockcost * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier;
                        }
                        else
                        {
                            var9 = mod_ModularForceFieldSystem.forcefieldblockcost;
                        }

                        if (var6.ffworld_getfistmode() == 1)
                        {
                            var9 *= mod_ModularForceFieldSystem.forcefieldblockzappermodifier;
                        }

                        ((TileEntityGeneratorCore)var7).Energylost(var9);
                    }
                }
            }

            this.energy_ticker = 0;
        }

        var4 = this.field_queue.iterator();

        while (var4.hasNext())
        {
            var5 = (String)var4.next();

            if (var2 == var3)
            {
                break;
            }

            var6 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var5);

            if (var6.ffworld_getfirstProjektor_ID() == this.getProjektor_ID() && var6.ffworld_getfistactive() && this.world.getChunkAtWorldCoords(var6.getX(), var6.getY()).d)
            {
                if (this.hardner)
                {
                    this.Hardnerdrop(var6.getX(), var6.getY(), var6.getZ());
                }

                if (!var6.ffworld_getfirstfreespace() && !this.world.getMaterial(var6.getX(), var6.getY(), var6.getZ()).isBuildable() && this.world.getTypeId(var6.getX(), var6.getY(), var6.getZ()) <= 124)
                {
                    var6.ffworld_setfirstfreeospace(true);
                }

                if (var6.ffworld_getfirstfreespace() && (this.world.getTypeId(var6.getX(), var6.getY(), var6.getZ()) != mod_ModularForceFieldSystem.MFFSFieldblock.id || !var6.getsync()))
                {
                    var6.setsync(true);
                    this.world.setTypeIdAndData(var6.getX(), var6.getY(), var6.getZ(), mod_ModularForceFieldSystem.MFFSFieldblock.id, var6.ffworld_getfistmode());
                    ++var2;
                }
            }
        }

        ++this.energy_ticker;
    }

    public int Forcepowerneed(int var1, boolean var2)
    {
        int var3 = var1 * mod_ModularForceFieldSystem.forcefieldblockcost;

        if (var2)
        {
            var3 = var3 * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier + var3 * 5;
        }

        return var3;
    }

    public void addfreqcard()
    {
        if (this.getItem(0) != null)
        {
            if (this.getItem(0).getItem() == mod_ModularForceFieldSystem.MFFSitemfc && this.linkGenerator_ID != Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID"))
            {
                this.linkGenerator_ID = Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID");
            }
        }
        else
        {
            this.linkGenerator_ID = 0;
        }
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.ProjektorItemStacks[var1] != null)
        {
            ItemStack var3;

            if (this.ProjektorItemStacks[var1].count <= var2)
            {
                var3 = this.ProjektorItemStacks[var1];
                this.ProjektorItemStacks[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.ProjektorItemStacks[var1].a(var2);

                if (this.ProjektorItemStacks[var1].count == 0)
                {
                    this.ProjektorItemStacks[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.ProjektorItemStacks[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public boolean canInteractWith(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.ProjektorItemStacks[var1];
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Projektor";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.ProjektorItemStacks.length;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}
}
