package mffs;

import ic2.common.TileEntityNuclearReactor;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityReaktorMonitor extends TileEntityPassivUpgrade implements IInventory
{
    private ItemStack[] inventory = new ItemStack[1];
    private boolean[] channel = new boolean[] {false, false, false, false, false, false};
    private int[] targetheat = new int[] {0, 0, 0, 0, 0};
    private int RMonitor_ID = 0;
    private boolean create = true;
    private int reaktorx;
    private int reaktory;
    private int reaktorz;
    private int heat;
    private boolean isreaktor;
    private boolean reaktoraktive = false;
    private int maxheat;
    private String Montorname = null;
    private int Montorname_ID = 0;

    public int[] getUpdate()
    {
        return new int[] {this.heat, this.maxheat, this.targetheat[0], this.targetheat[1], this.targetheat[2], this.targetheat[3], this.targetheat[4], this.RMonitor_ID, this.Montorname_ID};
    }

    public void handleUpdate(int[] var1)
    {
        this.heat = var1[0];
        this.maxheat = var1[1];

        for (int var2 = 0; var2 < 5; ++var2)
        {
            this.targetheat[var2] = var1[2 + var2];
        }

        this.RMonitor_ID = var1[7];
        this.Montorname_ID = var1[8];
        this.Montorname = "Monitor@" + this.Montorname_ID;
    }

    public void handleButton(int var1)
    {
        System.out.println("monitor handleButton(" + var1 + ")");

        switch (var1)
        {
            case 0:
                if (this.getTargetheat(0) <= this.getMaxheat())
                {
                    this.setTargetheat(0, this.getTargetheat(0) + 100);

                    if (this.getTargetheat(0) > this.getMaxheat())
                    {
                        this.setTargetheat(0, this.getMaxheat());
                    }
                }

                break;

            case 1:
                if (this.getTargetheat(0) >= 0)
                {
                    this.setTargetheat(0, this.getTargetheat(0) - 100);

                    if (this.getTargetheat(0) < 0)
                    {
                        this.setTargetheat(0, 0);
                    }
                }

                break;

            case 2:
                if (this.getTargetheat(1) <= this.getMaxheat())
                {
                    this.setTargetheat(1, this.getTargetheat(1) + 100);

                    if (this.getTargetheat(1) > this.getMaxheat())
                    {
                        this.setTargetheat(1, this.getMaxheat());
                    }
                }

                break;

            case 3:
                if (this.getTargetheat(1) >= 0)
                {
                    this.setTargetheat(1, this.getTargetheat(1) - 100);

                    if (this.getTargetheat(1) < 0)
                    {
                        this.setTargetheat(1, 0);
                    }
                }

                break;

            case 4:
                if (this.getTargetheat(2) <= this.getMaxheat())
                {
                    this.setTargetheat(2, this.getTargetheat(2) + 100);

                    if (this.getTargetheat(2) > this.getMaxheat())
                    {
                        this.setTargetheat(2, this.getMaxheat());
                    }
                }

                break;

            case 5:
                if (this.getTargetheat(2) >= 0)
                {
                    this.setTargetheat(2, this.getTargetheat(2) - 100);

                    if (this.getTargetheat(2) < 0)
                    {
                        this.setTargetheat(2, 0);
                    }
                }

                break;

            case 6:
                if (this.getTargetheat(3) <= this.getMaxheat())
                {
                    this.setTargetheat(3, this.getTargetheat(3) + 100);

                    if (this.getTargetheat(3) > this.getMaxheat())
                    {
                        this.setTargetheat(3, this.getMaxheat());
                    }
                }

                break;

            case 7:
                if (this.getTargetheat(3) >= 0)
                {
                    this.setTargetheat(3, this.getTargetheat(3) - 100);

                    if (this.getTargetheat(3) < 0)
                    {
                        this.setTargetheat(3, 0);
                    }
                }

                break;

            case 8:
                if (this.getTargetheat(4) <= this.getMaxheat())
                {
                    this.setTargetheat(4, this.getTargetheat(4) + 100);

                    if (this.getTargetheat(4) > this.getMaxheat())
                    {
                        this.setTargetheat(4, this.getMaxheat());
                    }
                }

                break;

            case 9:
                if (this.getTargetheat(4) >= 0)
                {
                    this.setTargetheat(4, this.getTargetheat(4) - 100);

                    if (this.getTargetheat(4) < 0)
                    {
                        this.setTargetheat(4, 0);
                    }
                }
        }
    }

    public int getRMonitor_ID()
    {
        return this.RMonitor_ID;
    }

    public void setRMonitor_ID(int var1)
    {
        this.RMonitor_ID = var1;
        ++this.updateCount;
    }

    public void freqencoding()
    {
        if (!this.world.isStatic && this.getItem(0) != null && this.getItem(0).getItem() == mod_ModularForceFieldSystem.MFFSitemcardempty)
        {
            this.setItem(0, new ItemStack(mod_ModularForceFieldSystem.MFFSitemsclc));
            Functions.getTAGfromItemstack(this.getItem(0)).setInt("RMonitorID", this.RMonitor_ID);
            this.update();
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getRMonitor().remove(Integer.valueOf(this.getRMonitor_ID()));
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        super.q_();

        if (!this.world.isStatic)
        {
            this.updatecheck();
            this.freqencoding();

            if (this.isIsreaktor())
            {
                TileEntity var1 = this.world.getTileEntity(this.reaktorx, this.reaktory, this.reaktorz);

                if (var1 == null)
                {
                    this.setIsreaktor(false);
                }

                if (var1 instanceof TileEntityNuclearReactor)
                {
                    this.heat = ((TileEntityNuclearReactor)var1).heat;
                    ++this.updateCount;
                    this.reaktoraktive = ((TileEntityNuclearReactor)var1).getActive();

                    if (this.reaktoraktive != this.channel[0])
                    {
                        this.channel[0] = this.reaktoraktive;
                    }

                    if (this.targetheat[0] < this.heat && !this.channel[1])
                    {
                        this.channel[1] = true;
                    }

                    if (this.targetheat[1] < this.heat && !this.channel[2])
                    {
                        this.channel[2] = true;
                    }

                    if (this.targetheat[2] < this.heat && !this.channel[3])
                    {
                        this.channel[3] = true;
                    }

                    if (this.targetheat[3] < this.heat && !this.channel[4])
                    {
                        this.channel[4] = true;
                    }

                    if (this.targetheat[4] < this.heat && !this.channel[5])
                    {
                        this.channel[5] = true;
                    }

                    if (this.targetheat[0] > this.heat && this.channel[1])
                    {
                        this.channel[1] = false;
                    }

                    if (this.targetheat[1] > this.heat && this.channel[2])
                    {
                        this.channel[2] = false;
                    }

                    if (this.targetheat[2] > this.heat && this.channel[3])
                    {
                        this.channel[3] = false;
                    }

                    if (this.targetheat[3] > this.heat && this.channel[4])
                    {
                        this.channel[4] = false;
                    }

                    if (this.targetheat[4] > this.heat && this.channel[5])
                    {
                        this.channel[5] = false;
                    }
                }
            }
            else
            {
                this.channel = new boolean[] {false, false, false, false, false, false};
            }

            if (this.create)
            {
                if (this.RMonitor_ID == 0)
                {
                    this.RMonitor_ID = Linkgrid.getWorldMap(this.world).newRMonitor_ID(this);
                    this.Montorname_ID = Linkgrid.getWorldMap(this.world).newRMonitor_Name("");
                    this.Montorname = "Monitor@" + this.Montorname_ID;
                    Linkgrid.getWorldMap(this.world).getRMonitor().put(Integer.valueOf(this.getRMonitor_ID()), this);
                }
                else
                {
                    Linkgrid.getWorldMap(this.world).getRMonitor().put(Integer.valueOf(this.getRMonitor_ID()), this);
                }

                this.create = false;
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.targetheat[0] = var1.getInt("targetheat0");
        this.targetheat[1] = var1.getInt("targetheat1");
        this.targetheat[2] = var1.getInt("targetheat2");
        this.targetheat[3] = var1.getInt("targetheat3");
        this.targetheat[4] = var1.getInt("targetheat4");
        this.Montorname_ID = var1.getInt("MontornameID");
        this.Montorname = var1.getString("Montorname");
        this.RMonitor_ID = var1.getInt("RMonitorID");
        NBTTagList var2 = var1.getList("Items");
        this.inventory = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.inventory.length)
            {
                this.inventory[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("targetheat0", this.targetheat[0]);
        var1.setInt("targetheat1", this.targetheat[1]);
        var1.setInt("targetheat2", this.targetheat[2]);
        var1.setInt("targetheat3", this.targetheat[3]);
        var1.setInt("targetheat4", this.targetheat[4]);
        var1.setInt("MontornameID", this.Montorname_ID);
        var1.setString("Montorname", this.Montorname);
        var1.setInt("RMonitorID", this.RMonitor_ID);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.inventory.length; ++var3)
        {
            if (this.inventory[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.inventory[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.inventory.length;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.inventory[var1];
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.inventory[var1] != null)
        {
            ItemStack var3;

            if (this.inventory[var1].count <= var2)
            {
                var3 = this.inventory[var1];
                this.inventory[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.inventory[var1].a(var2);

                if (this.inventory[var1].count == 0)
                {
                    this.inventory[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.inventory[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public void f() {}

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "ReaktorMonitor";
    }

    public void g() {}

    public int getHeat()
    {
        return this.heat;
    }

    public void setHeat(int var1)
    {
        this.heat = var1;
        ++this.updateCount;
    }

    public boolean isIsreaktor()
    {
        return this.isreaktor;
    }

    public void setIsreaktor(boolean var1)
    {
        this.isreaktor = var1;
        ++this.updateCount;
    }

    public int getReaktorx()
    {
        return this.reaktorx;
    }

    public void setReaktorx(int var1)
    {
        this.reaktorx = var1;
    }

    public int getReaktory()
    {
        return this.reaktory;
    }

    public void setReaktory(int var1)
    {
        this.reaktory = var1;
    }

    public int getReaktorz()
    {
        return this.reaktorz;
    }

    public void setReaktorz(int var1)
    {
        this.reaktorz = var1;
    }

    public boolean isReaktoraktive()
    {
        return this.reaktoraktive;
    }

    public boolean getChannel(int var1)
    {
        return this.channel[var1];
    }

    public boolean[] getChannel()
    {
        return this.channel;
    }

    public int getTargetheat(int var1)
    {
        return this.targetheat[var1];
    }

    public void setTargetheat(int var1, int var2)
    {
        this.targetheat[var1] = var2;
        ++this.updateCount;
    }

    public int getMaxheat()
    {
        return this.maxheat;
    }

    public void setMaxheat(int var1)
    {
        this.maxheat = var1;
        ++this.updateCount;
    }

    public String getMontorname()
    {
        return this.Montorname;
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
