package mods.immibis.redlogic;

import mods.immibis.redlogic.chips.ingame.TileIOMarker;
import mods.immibis.redlogic.gates.GateTile;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemScrewdriver extends Item {
	public ItemScrewdriver(int id_minus_256) {
		super(id_minus_256);
		setUnlocalizedName("redlogic.screwdriver");
		func_111206_d("redlogic:screwdriver");
		setCreativeTab(CreativeTabs.tabTools);
		setMaxStackSize(1);
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float par8, float par9, float par10) {
		if(w.getBlockId(x, y, z) == RedLogicMod.gates.blockID) {
		
			if(w.isRemote)
				return true;
			
			GateTile te = (GateTile)w.getBlockTileEntity(x, y, z);
			if(ply.isSneaking())
				te.configure();
			else
				te.rotate();
			
			return true;
		}
		
		if(w.getBlockId(x, y, z) == RedLogicMod.machineBlock.blockID) {
			TileEntity te = w.getBlockTileEntity(x, y, z);
			if(te instanceof TileIOMarker) {
				if(!w.isRemote)
					((TileIOMarker)te).toggleMode();
				return true;
			}
			
			return false;
		}
		
		return false;
	}
}
