package mods.immibis.redlogic;

import mods.immibis.cobaltite.AssignedBlock;
import mods.immibis.cobaltite.AssignedItem;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.Configurable;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.TileGUI;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.util.Colour;
import mods.immibis.redlogic.chips.builtin.RegisterScannables;
import mods.immibis.redlogic.chips.generated.CCOFactory;
import mods.immibis.redlogic.chips.ingame.*;
import mods.immibis.redlogic.gates.*;
import mods.immibis.redlogic.lamps.BlockLampCube;
import mods.immibis.redlogic.lamps.ItemLampCube;
import mods.immibis.redlogic.wires.BundledTile;
import mods.immibis.redlogic.wires.EnumWireType;
import mods.immibis.redlogic.wires.InsulatedRedAlloyTile;
import mods.immibis.redlogic.wires.PlainRedAlloyTile;
import mods.immibis.redlogic.wires.WireBlock;
import mods.immibis.redlogic.wires.WireDamageValues;
import mods.immibis.redlogic.wires.WireItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.ISaveHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid="RedLogic", name="RedLogic", version="56.1.0", dependencies="required-after:ImmibisCore")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
@CobaltiteMod(
		tiles = {
				@RegisteredTile(id="immibis.redlogic.gate", tile=GateTile.class, render="mods.immibis.redlogic.gates.GateDynamicRenderer"),
				@RegisteredTile(id="immibis.redlogic.wire.redalloy", tile=PlainRedAlloyTile.class),
				@RegisteredTile(id="immibis.redlogic.wire.insulated", tile=InsulatedRedAlloyTile.class),
				@RegisteredTile(id="immibis.redlogic.wire.bundled", tile=BundledTile.class),
				@RegisteredTile(id="immibis.redlogic.invalid", tile=InvalidTile.class),
				@RegisteredTile(id="immibis.redlogic.chipscanner", tile=TileChipScanner.class, render="mods.immibis.redlogic.chips.ingame.RenderTileChipScanner"),
				@RegisteredTile(id="immibis.redlogic.circuit", tile=TileCustomCircuit.class),
				@RegisteredTile(id="immibis.redlogic.chipiomarker", tile=TileIOMarker.class),
				@RegisteredTile(id="immibis.redlogic.chipcompiler", tile=TileChipCompiler.class, render="mods.immibis.redlogic.chips.ingame.RenderTileChipCompiler"),
				@RegisteredTile(id="immibis.redlogic.chipfabricator", tile=TileChipFabricator.class),
		}
	)
@FMLModInfo(authors = "immibis", description = "Replacement for RP2 Wiring, Logic and Control",
	url="http://www.minecraftforum.net/topic/1852277-152-redlogic-wip-replacement-for-rp2-wiringlogiccontrollighting/")
public class RedLogicMod extends ModBase {

	@TileGUI(container=TimerContainer.class, gui=TimerGui.class)
	public static final int GUI_TIMER = 0;

	@TileGUI(container=CounterContainer.class, gui=CounterGui.class)
	public static final int GUI_COUNTER = 1;
	
	@TileGUI(container=ContainerChipFabricator.class, gui=GuiChipFabricator.class)
	public static final int GUI_CHIP_FABRICATOR = 2;

	public static final String CHANNEL = "RedLogic";

	@Instance("RedLogic")
	public static RedLogicMod instance;

	@AssignedBlock(id="gates", item=GateItem.class)
	public static GateBlock gates;

	@AssignedBlock(id="wire", item=WireItem.class)
	public static WireBlock wire;
	
	@AssignedBlock(id="lampCubeOn", item=ItemLampCube.class)
	public static BlockLampCube.On lampCubeOn;
	@AssignedBlock(id="lampCubeOff", item=ItemLampCube.class)
	public static BlockLampCube.Off lampCubeOff;
	@AssignedBlock(id="lampCubeDecorative", item=ItemLampCube.class)
	public static BlockLampCube.Decorative lampCubeDecorative;
	@AssignedBlock(id="lampCubeIndicatorOn", item=ItemLampCube.class)
	public static BlockLampCube.IndicatorOn lampCubeIndicatorOn;
	@AssignedBlock(id="lampCubeIndicatorOff", item=ItemLampCube.class)
	public static BlockLampCube.IndicatorOff lampCubeIndicatorOff;
	
	@AssignedBlock(id="plainBlock", item=RLNormalBlockItem.class)
	public static RLNormalBlock plainBlock;
	
	@AssignedBlock(id="machineBlock", item=RLMachineBlockItem.class)
	public static RLMachineBlock machineBlock;
	
	@AssignedBlock(id="customCircuitBlock")
	public static BlockCustomCircuit customCircuitBlock;

	@AssignedItem(id="screwdriver")
	public static ItemScrewdriver screwdriver;
	
	@AssignedItem(id="compiledCircuit")
	public static ItemPhotomask photomaskItem;
	
	@AssignedItem(id="schematic")
	public static ItemSchematic schematicItem;
	
	@AssignedItem(id="chip")
	public static ItemChip chipItem;
	
	@Configurable("minTimerTicks")
	public static int minTimerTicks = 4;
	
	@Configurable("defaultTimerTicks")
	public static int defaultTimerTicks = 20;

	public static Material circuitMaterial = new MaterialLogic(Material.circuits.materialMapColor) {
		@Override
		public boolean blocksMovement() {
			// required for water to not wash away things, but has other side effects...
			return true;
		}
	};

	@EventHandler public void init(FMLInitializationEvent evt) {super._init(evt);}
	@EventHandler public void preinit(FMLPreInitializationEvent evt) {super._preinit(evt);}

	@Override
	protected void initBlocksAndItems() {
		RegisterScannables.register();
	}
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(screwdriver),
			" YI",
			" IB",
			"/  ",
			'Y', new ItemStack(Item.dyePowder, 1, Colour.YELLOW.dyeId()),
			'B', new ItemStack(Item.dyePowder, 1, Colour.BLACK.dyeId()),
			'/', Item.stick,
			'I', Item.ingotIron
			);
		
		GameRegistry.addRecipe(new ItemStack(wire, 16, EnumWireType.RED_ALLOY.ordinal()),
			"R R",
			"RIR",
			"R R",
			'R', Item.redstone,
			'I', Item.ingotIron
			);
		
		for(int k = 0; k < 16; k++) {
			GameRegistry.addRecipe(new ItemStack(wire, 8, EnumWireType.INSULATED_WIRE[k].ordinal()),
				"WWW",
				"WDW",
				"WWW",
				'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
				'D', new ItemStack(Item.dyePowder, 1, 15 - k));
			
			GameRegistry.addRecipe(new ItemStack(wire, 8, EnumWireType.INSULATED_WIRE[k].ordinal()),
				"WWW",
				"WDW",
				"WWW",
				'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
				'D', new ItemStack(Block.cloth, 1, k));
		}
		
		GameRegistry.addRecipe(new ItemStack(wire, 2, EnumWireType.BUNDLED.ordinal()),
			"WWW",
			"WSW",
			"WWW",
			'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
			'S', Item.silk
		);
		
		for(EnumWireType type : EnumWireType.VALUES) {
			if(!type.hasJacketedForm())
				continue;
			
			ItemStack plain = new ItemStack(wire, 1, type.ordinal());
			ItemStack free = new ItemStack(wire, 1, type.ordinal() | WireDamageValues.DMG_FLAG_JACKETED);
			
			GameRegistry.addRecipe(plain, "X", 'X', free);
			GameRegistry.addRecipe(free, "X", 'X', plain);
		}
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			" T ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.OR.ordinal()),
			" T ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOT.ordinal()),
			" R ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			"STR",
			"R R",
			"RTS",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.cobblestone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.TOGGLE.ordinal()),
			" T ",
			"RLR",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'L', Block.lever);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOR.ordinal()),
			" T ",
			"RRR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NAND.ordinal()),
			" R ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XOR.ordinal()),
			"RRR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XNOR.ordinal()),
			"RTR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Buffer.ordinal()),
			"RTR",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Multiplexer.ordinal()),
			"RTR",
			"T T",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Repeater.ordinal()),
			"RRR",
			"R_R",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'_', Item.redstoneRepeater);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Timer.ordinal()),
			" T ",
			"RIR",
			"   ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Counter.ordinal()),
			"T  ",
			"IRR",
			"T  ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Sequencer.ordinal()),
			" T ",
			"TIT",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.PulseFormer.ordinal()),
			"RTR",
			"TRT",
			"RR ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Randomizer.ordinal()),
			" T ",
			"TGT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'G', Item.glowstone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.StateCell.ordinal()),
			" RT",
			"RXI",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Synchronizer.ordinal()),
			"RTR",
			"XRX",
			"R R",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.DLatch.ordinal()),
			"XTR",
			"TRR",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.DFlop.ordinal()),
			"XTR",
			"TRY",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			'Y', new ItemStack(gates, 1, EnumGates.PulseFormer.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledLatch.ordinal()),
			" B ",
			" DR",
			" B ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'D', new ItemStack(gates, 1, EnumGates.DLatch.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledRelay.ordinal()),
			" B ",
			" AR",
			" B ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'A', new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledMultiplexer.ordinal()),
			" B ",
			"BMB",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.Multiplexer.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		for(int k = 0; k < 16; k++) {
			GameRegistry.addRecipe(new ItemStack(lampCubeIndicatorOff, 1, k),
				"GrG",
				"GrG",
				"GdG",
				'G', Block.glass,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			GameRegistry.addRecipe(new ItemStack(lampCubeOff, 1, k),
				"GrG",
				"GgG",
				"GdG",
				'G', Block.glass,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone,
				'g', Block.glowStone);
			GameRegistry.addRecipe(new ItemStack(lampCubeDecorative, 1, k),
				"G G",
				"GgG",
				"GdG",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
		}
		
		GameRegistry.addRecipe(new ItemStack(plainBlock, 16, RLNormalBlock.META_CLEANWALL),
			"SBS",
			"ISI",
			"SBS",
			'S', Block.sand,
			'I', Item.ingotIron,
			'B', Block.brick);
		
		GameRegistry.addRecipe(new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANFILTER),
			"BBB",
			"BWB",
			"BBB",
			'B', Block.fenceIron,
			'W', new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANWALL));
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_SCANNER),
			"RRR",
			"RWR",
			"RDR",
			'R', Item.redstone,
			'D', Item.diamond,
			'W', new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANWALL));
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_IO_MARKER),
			"OOO",
			"OGO",
			"ORO",
			'R', Item.redstone,
			'O', Block.obsidian,
			'G', Block.blockGold);
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_COMPILER),
			"ORR",
			"ODR",
			"OYR",
			'D', Block.blockDiamond,
			'O', Block.obsidian,
			'R', Item.redstone,
			'Y', new ItemStack(Item.dyePowder, 1, Colour.YELLOW.dyeId())
			);
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_FABRICATOR),
			"ORR",
			"OIR",
			"OWR",
			'I', Block.blockIron,
			'O', Block.obsidian,
			'R', Item.redstone,
			'W', new ItemStack(Item.dyePowder, 1, Colour.WHITE.dyeId())
			);
	}
	
	@EventHandler
	public void onServerStarting(FMLServerStartingEvent evt) {
		evt.registerServerCommand(new CommandDebug());
		
		ISaveHandler saveHandler = evt.getServer().worldServerForDimension(0).getSaveHandler();
		CCOFactory.instance = new CCOFactory(saveHandler.getMapFileFromName("redlogic-compiled-circuit-cache"));
	}
	
	@EventHandler
	public void onServerStopped(FMLServerStoppedEvent evt) {
		CCOFactory.instance = null;
	}
}
