package mods.immibis.redlogic.api.chips.scanner;

import net.minecraft.util.ChatMessageComponent;

/**
 * Can be thrown from some methods to abort the scanning process and display a message to the player.
 */
public class CircuitLayoutException extends Exception {
	private static final long serialVersionUID = 1L;
	
	private final ChatMessageComponent display;
	
	public CircuitLayoutException(String exceptionMessage, ChatMessageComponent display) {
		super(exceptionMessage);
		this.display = display;
	}
	
	public CircuitLayoutException(ChatMessageComponent display) {
		this(display.toString(), display);
	}

	public ChatMessageComponent getDisplayMessage() {
		return display;
	}
}
