package mods.immibis.redlogic;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class RLNormalBlock extends Block {
	public static final int META_CLEANWALL = 0;
	public static final int META_CLEANFILTER = 1;

	public RLNormalBlock(int id) {
		super(id, Material.iron);
		
		setHardness(5.0F);
		setResistance(10.0F);
		setStepSound(soundMetalFootstep);
		setCreativeTab(CreativeTabs.tabBlock);
	}
	
	private Icon[] icons;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		icons = new Icon[16];
		icons[META_CLEANWALL] = reg.registerIcon("redlogic:cleanwall");
		icons[META_CLEANFILTER] = reg.registerIcon("redlogic:cleanfilter");
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List list) {
		list.add(new ItemStack(this, 1, META_CLEANWALL));
		list.add(new ItemStack(this, 1, META_CLEANFILTER));
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public Icon getIcon(int side, int meta) {
		return icons[meta];
	}
}
