/*
 * Decompiled with CFR 0.152.
 */
package immibis.tubestuff;

import forge.ForgeHooks;
import forge.ISidedInventory;
import immibis.core.GuiSystem;
import immibis.core.TileBasicInventory;
import immibis.tubestuff.ContainerCraftingTable;
import immibis.tubestuff.InventoryCraftingACT2;
import java.util.logging.Level;

public class TileCraftingTable
extends TileBasicInventory
implements ISidedInventory {
    static final int SLOT_OUTPUT = 0;
    static final int START_RECIPE = 1;
    static final int SIZE_RECIPE = 9;
    static final int START_INPUT = 10;
    static final int SIZE_INPUT = 45;
    static final int START_OVERFLOW = 46;
    static final int SIZE_OVERFLOW = 9;
    static final int INVSIZE = 55;
    private eu cachedRecipe;
    private boolean invChanged = true;
    private boolean recipeChanged = true;
    private boolean outputFull = false;
    private boolean insufficientInput = false;
    private int pulse_ticks = 0;
    private static boolean allowCraftingHook = true;

    public int getStartInventorySide(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 46;
            }
        }
        return 10 + 11 * (n - 2);
    }

    public int getSizeInventorySide(int n) {
        return n == 1 ? 1 : 9;
    }

    public TileCraftingTable() {
        super(55, "ACT Mk II");
    }

    private nx makeInventoryCrafting(int n) {
        InventoryCraftingACT2 inventoryCraftingACT2 = new InventoryCraftingACT2();
        for (int i = 0; i < 9; ++i) {
            inventoryCraftingACT2.a(i, this.inv.contents[i + n]);
        }
        return inventoryCraftingACT2;
    }

    private void cacheOutput() {
        nx nx2 = this.makeInventoryCrafting(1);
        for (eu eu2 : iz.a().b()) {
            if (!eu2.a(nx2)) continue;
            this.cachedRecipe = eu2;
            return;
        }
        this.cachedRecipe = null;
    }

    public static final boolean areItemsEqual(kn kn2, kn kn3) {
        return kn3.c == kn2.c && (!kn3.e() || kn3.h() == kn2.h());
    }

    private void makeOutput() {
        int n;
        if (this.inv.contents[0] != null) {
            return;
        }
        if (this.cachedRecipe == null) {
            return;
        }
        int[] nArray = new int[9];
        int[] nArray2 = new int[45];
        for (int i = 0; i < 9; ++i) {
            kn kn2 = this.inv.contents[i + 1];
            nArray[i] = -1;
            if (kn2 == null) continue;
            for (int j = 0; j < 45; ++j) {
                kn kn3 = this.inv.contents[j + 10];
                if (kn3 == null || nArray2[j] >= kn3.a || !TileCraftingTable.areItemsEqual(kn2, kn3)) continue;
                nArray[i] = j;
                int n2 = j;
                nArray2[n2] = nArray2[n2] + 1;
                break;
            }
            if (nArray[i] != -1) continue;
            this.insufficientInput = true;
            return;
        }
        InventoryCraftingACT2 inventoryCraftingACT2 = new InventoryCraftingACT2();
        for (n = 0; n < 9; ++n) {
            if (nArray[n] == -1) continue;
            inventoryCraftingACT2.a(n, this.inv.contents[nArray[n] + 10]);
        }
        if (!this.cachedRecipe.a((nx)inventoryCraftingACT2)) {
            this.insufficientInput = true;
            return;
        }
        for (n = 0; n < 9; ++n) {
            if (nArray[n] == -1) continue;
            inventoryCraftingACT2.a(n, this.inv.decrStackSize(nArray[n] + 10, 1));
        }
        this.inv.contents[0] = this.cachedRecipe.b((nx)inventoryCraftingACT2);
        this.decreaseInput(inventoryCraftingACT2, this.inv.contents[0]);
        for (n = 0; n < 9; ++n) {
            kn kn4 = inventoryCraftingACT2.g_(n);
            if (kn4 == null) continue;
            this.inv.mergeStackIntoRange(kn4, 46, 55);
        }
        this.invChanged = true;
        this.H_();
    }

    private void decreaseInput(nx nx2, kn kn2) {
        if (allowCraftingHook) {
            try {
                ModLoader.takenFromCrafting(null, (kn)kn2, (ng)nx2);
                ForgeHooks.onTakenFromCrafting(null, (kn)kn2, (ng)nx2);
                ib.d[kn2.c].d(kn2, this.k, null);
            }
            catch (Exception exception) {
                allowCraftingHook = false;
                exception.printStackTrace();
                ModLoader.getLogger().log(Level.WARNING, "TubeStuff: This happened when trying to call a crafting hook with a null player. I won't try that again, but this may cause some bugs. If you can tell which mod caused the problem, bug its author to fix it.");
            }
        }
        for (int i = 0; i < nx2.c(); ++i) {
            kn kn3 = nx2.g_(i);
            if (kn3 == null) continue;
            nx2.a(i, 1);
            if (!kn3.a().k()) continue;
            kn kn4 = new kn(kn3.a().j());
            if (nx2.g_(i) == null) {
                nx2.a(i, kn4);
                continue;
            }
            this.inv.mergeStackIntoRange(kn4, 46, 55);
        }
    }

    public void q_() {
        if (this.inv.contents[0] == null) {
            if (this.recipeChanged) {
                this.cacheOutput();
                this.recipeChanged = false;
            }
            if (this.cachedRecipe != null && !this.insufficientInput) {
                this.makeOutput();
            }
        }
        if (this.inv.contents[0] != null) {
            this.pulse_ticks = (this.pulse_ticks + 1) % 20;
            if (this.pulse_ticks == 0) {
                this.redstone_output = !this.redstone_output;
                this.notifyNeighbouringBlocks();
            }
        } else if (this.redstone_output) {
            this.redstone_output = false;
            this.notifyNeighbouringBlocks();
        }
        if (this.invChanged) {
            this.invChanged = false;
            this.insufficientInput = false;
        }
    }

    public boolean onBlockActivated(if if_) {
        GuiSystem.OpenStringGUI(TileCraftingTable.class, (String)"gui", (if)if_, (ev)new ContainerCraftingTable((ng)if_.k, (ng)this), (qh)this);
        return true;
    }

    private void slotChanging(int n) {
        if (n == 0) {
            this.outputFull = false;
        }
        if (n >= 1 && n < 10) {
            this.recipeChanged = true;
        }
        this.invChanged = true;
        this.insufficientInput = false;
    }

    public kn a(int n, int n2) {
        this.slotChanging(n);
        return super.a(n, n2);
    }

    public void a(int n, kn kn2) {
        this.slotChanging(n);
        super.a(n, kn2);
    }
}

