package immibis.tubestuff;

/* $if jclient$ */

import org.lwjgl.opengl.GL11;

import immibis.core.aspects.ClientOnly;
import immibis.tubestuff.ContainerAutoCraftingMk2;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.IInventory;

@ClientOnly
public class GuiAutoCraftingMk2 extends GuiContainer {
	private ContainerAutoCraftingMk2 container;
	public GuiAutoCraftingMk2(EntityPlayer player, TileAutoCraftingMk2 table) {
		super(new ContainerAutoCraftingMk2(player, table));
		container = (ContainerAutoCraftingMk2)inventorySlots;
		
		xSize = 186;
		ySize = 249; 
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		int k = mc.renderEngine.getTexture("/immibis/tubestuff/crafting-gui.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        
        stackButton.displayString = container.tile.craftMany ? "64" : "1";
	}
	
	private GuiButton stackButton;
	
	@Override
	public void initGui() {
		super.initGui();
		
		stackButton = new GuiButton(0, guiLeft + 156, guiTop + 122, 20, 20, container.tile.craftMany ? "64" : "1");
		
		controlList.add(stackButton);
	}
	
	@Override
	protected void actionPerformed(GuiButton par1GuiButton) {
		System.out.println("actionPerformed "+par1GuiButton);
		if(par1GuiButton == stackButton)
			((ContainerAutoCraftingMk2)inventorySlots).sendButtonPressed(0);
		else
			super.actionPerformed(par1GuiButton);
	}
}

/* $endif$ */
