package immibis.chunkloader;

import immibis.core.Config;

import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
/* $if jclient$ */
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

/* $if mc > 1.3$ */
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.asm.SideOnly;
/* $endif$ */
/* $endif$ */
/* $if jserver$ */
import net.minecraft.server.MinecraftServer;
/* $endif$ */
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
/* $if mc > 1.3$ */
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.common.*;
/* $endif$ */

import java.util.*;

public class Main extends PortableBaseMod
/* $if mc < 1.3$
    implements net.minecraft.src.forge.IChunkLoadHandler
$endif$ */
{
	
	// IDEAS
	// * Let a redstone signal deactivate the chunk loader, removing it from the quota.
	//   This would mean a player would have to reactivate it manually, in most cases,
	//   since the redstone circuit would become unloaded.
	// * Let a *wireless* redstone signal do that.
	
	// GUI IDs
	public static final int GUI_CHUNKLOADER = 0;
	
	// Packet IDs
	public static final byte S2C_GUI_UPDATE = 0;
	public static final byte C2S_DATA_REQUEST = 1;
	public static final byte S2C_DATA_RESPONSE = 2;
	
	public static final String CHANNEL =  "immibis.chunkldr";
	
	public static final int MAX_RADIUS = 4; // 9x9 area
	
	public Map<World, WorldInfo> worlds = new HashMap<World, WorldInfo>();
	
	public int maxQuota = 18;
	public boolean showOtherPlayersLoaders = false;
	
	public static boolean DEBUG = false;
	
	/* $if joined$ */
	public static @cpw.mods.fml.common.SidedProxy(clientSide="immibis.chunkloader.ClientProxy",serverSide="immibis.chunkloader.BaseProxy") BaseProxy proxy;
	/* $elseif jclient$
	public static BaseProxy proxy = new ClientProxy();
	$else$
	public static BaseProxy proxy = new BaseProxy();
	$endif$ */
	
	// Checks whether the game is still using this World object
	public boolean isWorldCurrent(World w) {
		return SidedProxy.instance.isWorldCurrent(w);
	}
	
	public String getPriorities() {
		return "after:mod_ImmibisCore;";
	}
	
	public WorldInfo getWorld(World w) {
		WorldInfo wi = worlds.get(w);
		if(wi != null)
			return wi;
		wi = WorldInfo.get(w);
		worlds.put(w, wi);
		Logging.onLoadWorld(wi);
		return wi;
	}
	
	public static Main instance;
	
	public Main() {
		instance = this;
	}
	
	public BlockChunkLoader block;

	@Override
	public boolean clientSideRequired() {
		return true;
	}

	@Override
	public boolean serverSideRequired() {
		return false;
	}

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/chunkloader/mod_ImmiChunkLoaders.info.txt", "version");
	}
	
	/* $if client2$ */
	/* $if joined$ */
	@SideOnly(Side.CLIENT)
	/* $endif$ */
	public KeyBinding seeChunksKey;
	/* $endif$ */

	@Override
	public void load() {
		IDAllocator.RegisterBlockID("chunkloader", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockChunkLoader(id);
				ModLoader.registerBlock(block, ItemChunkLoader.class);
				
				ModLoader.addRecipe(new ItemStack(block, 1, 0),
					" G ",
					"GIG",
					" G ",
					'G', Item.ingotGold,
					'I', Block.blockSteel
				);
			}
		});

		ModLoader.registerTileEntity(TileChunkLoader.class, "immibis.chunkloader.TileChunkLoader");
		enableClockTicks(true);
		
		proxy.load();
		
		/* $if mc < 1.3$
		MinecraftForge.registerChunkLoadHandler(this);
		$endif$ */
		
		SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler() {
			
			/* $if jclient$ */
			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				if(ID == GUI_CHUNKLOADER)
					return new GuiChunkLoader(new ContainerChunkLoader(player, (TileChunkLoader)tile)); 
				return null;
			}
			/* $endif$ */
			
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				if(ID == GUI_CHUNKLOADER)
					return new ContainerChunkLoader(player, (TileChunkLoader)tile);
				return null;
			}
		});
		
		OneTwoFiveNetworking.initReceiveClient(new PacketMap(), CHANNEL);
		OneTwoFiveNetworking.initReceiveServer(new PacketMap(), CHANNEL);
		
		/* $if jserver$ */
		if(SidedProxy.instance.isDedicatedServer()) {
			maxQuota = Config.getInt("chunkloader.maxChunksPerPlayer", 3);
			showOtherPlayersLoaders = !Config.getBoolean("chunkloader.hideOtherPlayersLoadersInF9", true);
		}
		/* $endif$ */
		
		String logName = Config.getString("chunkloader.logFileName", !SidedProxy.instance.isDedicatedServer() ? "" : "dimensional-anchors.log", "logging", "Name of a file to log creation, deletion and editing of chunk loaders to. Blank for none.").trim();
		String listName = Config.getString("chunkloader.listFileName", "", "logging", "Name of a file to keep updated with a list of all active chunk loaders. Blank for none.").trim();
		
		if(!logName.isEmpty()) Logging.openLog(logName);
		if(!listName.isEmpty()) Logging.setList(listName);
	}
	
	/* $if jclient && mc < 1.3$
	@Override
	public void keyboardEvent(KeyBinding key) {
		proxy.keyboardEvent(key);
	}
	$endif$ */
	
	@Override
	public boolean onTickInGame() {
		Set<World> toRemove = new HashSet<World>();
		for(Map.Entry<World, WorldInfo> e : worlds.entrySet()) {
			if(!isWorldCurrent(e.getKey())) {
				toRemove.add(e.getKey());
				Logging.onUnloadWorld(e.getValue());
			} else {
				e.getValue().tick();
			}
		}
		for(World w : toRemove)
			worlds.remove(w);
		Logging.flushLog();
		return true;
	}

	/* $if mc < 1.3$
	@Override
	public boolean canUpdateEntity(Entity entity) {
		return getWorld(entity.worldObj).isChunkForceLoaded(new ChunkCoordIntPair(entity.chunkCoordX, entity.chunkCoordZ));
	}
	
	@Override
	public boolean canUnloadChunk(Chunk chunk) {
		return !getWorld(chunk.worldObj).isChunkForceLoaded(chunk.getChunkCoordIntPair());
	}
	
	@Override
	public void addActiveChunks(World world, Set<ChunkCoordIntPair> chunkList) {
		chunkList.addAll(getWorld(world).getLoadedChunks());
	}
	$endif$ */

	public int getCurQuota(String player) {
		int r = 0;
		for(Map.Entry<World, WorldInfo> e : worlds.entrySet()) {
			int _this = e.getValue().getCurQuota(player);
			r += _this;
			//System.out.println(e.getKey()+" " + player + " -> " + _this);
		}
		return r;
	}

	public int getMaxQuota(String player) {
		return SidedProxy.instance.isOp(player) ? -2 : maxQuota;
		//return maxQuota;
	}

	public boolean canAddQuota(String player, int i) {
		if(i <= 0)
			return true;
		int max = getMaxQuota(player);
		if(max == -2)
			return true;
		return getCurQuota(player) + i <= max;
	}

	public static Iterable<WorldInfo> allWorlds() {
		return instance.worlds.values();
	}
	
	private static class PacketMap implements IPacketMap {
		@Override
		public IPacket createPacket(byte id) {
			if(id == S2C_GUI_UPDATE)
				return new PacketGUIUpdate("", 0, 0, 0, false, false);
			if(id == C2S_DATA_REQUEST)
				return new PacketShowChunksRequest();
			if(id == S2C_DATA_RESPONSE)
				return new PacketShowChunksResponse();
			return null;
		}
	}
}
