package immibis.chunkloader;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.EntityPlayer;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.IPacket;

public class PacketShowChunksResponse implements IPacket {
	
	public Collection<LoadedChunkDisplay> list = new LinkedList<LoadedChunkDisplay>();
	
	public PacketShowChunksResponse() {
	}
	
	public PacketShowChunksResponse(EntityPlayer from) { 
		for(WorldInfo.LoaderInfo li : Main.instance.getWorld(from.worldObj).getAllLoaders()) {
			if(from.getDistanceSq(li.pos.x, li.pos.y, li.pos.z) > 65536)
				continue; // don't show loaders more than 16 chunks away
			boolean owned = li.player.equals(from.username);
			if(!owned && !Main.instance.showOtherPlayersLoaders && !SidedProxy.instance.isOp(from.username))
				continue;
			for(ChunkCoordIntPair cc : li.getLoadedChunks()) {
				LoadedChunkDisplay lcd = new LoadedChunkDisplay();
				lcd.chunkX = cc.chunkXPos;
				/* $if mc < 1.3$
				lcd.chunkZ = cc.chunkZPosition;
				$else$ */
				lcd.chunkZ = cc.chunkZPos;
				/* $endif$ */
				lcd.loaderX = li.pos.x;
				lcd.loaderY = li.pos.y;
				lcd.loaderZ = li.pos.z;
				lcd.isOwned = owned;
				list.add(lcd);
			}
		}
	}

	@Override
	public byte getID() {
		return Main.S2C_DATA_RESPONSE;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		list.clear();
		
		int size = in.readInt();
		for(int k = 0; k < size; k++) {
			LoadedChunkDisplay lcd = new LoadedChunkDisplay();
			lcd.chunkX = in.readInt();
			lcd.chunkZ = in.readInt();
			lcd.loaderX = in.readByte() + (lcd.chunkX << 4);
			lcd.loaderY = in.readByte() & 255;
			lcd.loaderZ = in.readByte() + (lcd.chunkZ << 4);
			lcd.isOwned = in.readBoolean();
			list.add(lcd);
		}
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(list.size());
		for(LoadedChunkDisplay lcd : list) {
			out.writeInt(lcd.chunkX);
			out.writeInt(lcd.chunkZ);
			out.writeByte(lcd.loaderX - (lcd.chunkX << 4));
			out.writeByte((byte)lcd.loaderY);
			out.writeByte(lcd.loaderZ - (lcd.chunkZ << 4));
			out.writeBoolean(lcd.isOwned);
		}
	}

	@Override
	public void onReceived(EntityPlayer source) {
		if(!SidedProxy.instance.isDedicatedServer())
			Main.instance.proxy.loadedChunkDisplays = list;
	}

}
