package immibis.chunkloader;

import immibis.core.api.porting.SidedProxy;
import immibis.core.net.IPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.EntityHuman;

public class PacketShowChunksResponse implements IPacket
{
    public Collection list = new LinkedList();

    public PacketShowChunksResponse() {}

    public PacketShowChunksResponse(EntityHuman var1)
    {
        mod_DimensionalAnchors var10000 = mod_DimensionalAnchors.instance;
        Iterator var3 = mod_DimensionalAnchors.getWorld(var1.world).getAllLoaders().iterator();

        while (var3.hasNext())
        {
            WorldInfo.LoaderInfo var2 = (WorldInfo.LoaderInfo)var3.next();

            if (var1.e((double)var2.pos.x, (double)var2.pos.y, (double)var2.pos.z) <= 65536.0D)
            {
                boolean var4 = var2.player.equals(var1.name);

                if (var4 || mod_DimensionalAnchors.showOtherPlayersLoaders || SidedProxy.instance.isOp(var1.name))
                {
                    Iterator var6 = var2.getLoadedChunks().iterator();

                    while (var6.hasNext())
                    {
                        ChunkCoordIntPair var5 = (ChunkCoordIntPair)var6.next();
                        LoadedChunkDisplay var7 = new LoadedChunkDisplay();
                        var7.chunkX = var5.x;
                        var7.chunkZ = var5.z;
                        var7.loaderX = var2.pos.x;
                        var7.loaderY = var2.pos.y;
                        var7.loaderZ = var2.pos.z;
                        var7.isOwned = var4;
                        this.list.add(var7);
                    }
                }
            }
        }
    }

    public byte getID()
    {
        return (byte)2;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.list.clear();
        int var2 = var1.readInt();

        for (int var3 = 0; var3 < var2; ++var3)
        {
            LoadedChunkDisplay var4 = new LoadedChunkDisplay();
            var4.chunkX = var1.readInt();
            var4.chunkZ = var1.readInt();
            var4.loaderX = var1.readByte() + (var4.chunkX << 4);
            var4.loaderY = var1.readByte() & 255;
            var4.loaderZ = var1.readByte() + (var4.chunkZ << 4);
            var4.isOwned = var1.readBoolean();
            this.list.add(var4);
        }
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeInt(this.list.size());
        Iterator var3 = this.list.iterator();

        while (var3.hasNext())
        {
            LoadedChunkDisplay var2 = (LoadedChunkDisplay)var3.next();
            var1.writeInt(var2.chunkX);
            var1.writeInt(var2.chunkZ);
            var1.writeByte(var2.loaderX - (var2.chunkX << 4));
            var1.writeByte((byte)var2.loaderY);
            var1.writeByte(var2.loaderZ - (var2.chunkZ << 4));
            var1.writeBoolean(var2.isOwned);
        }
    }

    public void onReceived(EntityHuman var1)
    {
        if (var1 == null && !SidedProxy.instance.isDedicatedServer())
        {
            mod_DimensionalAnchors.proxy.loadedChunkDisplays = this.list;
            mod_DimensionalAnchors.proxy.showingChunks = true;
        }
    }
}
