package immibis.chunkloader;

import forge.Configuration;
import forge.Property;
import immibis.chunkloader.porting.ChunkLoadInterface;
import immibis.chunkloader.porting.ChunkLoadInterface125;
import immibis.chunkloader.quota.Quota;
import immibis.core.Config;
import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;
import java.util.logging.Logger;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class mod_DimensionalAnchors extends PortableBaseMod
{
    public static Logger logger = Logger.getLogger("DimensionalAnchors");
    public static final int GUI_CHUNKLOADER = 0;
    public static final int GUI_CHUNKLOADER_FUELED = 1;
    public static final byte S2C_GUI_UPDATE = 0;
    public static final byte C2S_DATA_REQUEST = 1;
    public static final byte S2C_DATA_RESPONSE = 2;
    public static final String CHANNEL = "immibis.chunkldr";
    public static final int MAX_RADIUS = 4;
    public static boolean DEBUG = true;
    public static Map worlds = new HashMap();
    public static boolean showOtherPlayersLoaders = false;
    public static ChunkLoadInterface cli;
    public static Quota quota;
    public static boolean requireFuel;
    public static boolean allowFuelPiping;
    public static Map playerQuotaOverride;
    public static BaseProxy proxy = new BaseProxy();
    public static mod_DimensionalAnchors instance;
    public BlockChunkLoader block;
    public static HashMap commands = new HashMap();

    public boolean isWorldCurrent(World var1)
    {
        return SidedProxy.instance.isWorldCurrent(var1);
    }

    public String getPriorities()
    {
        return "after:mod_ImmibisCore;";
    }

    public static WorldInfo getWorld(World var0)
    {
        WorldInfo var1 = (WorldInfo)worlds.get(var0);

        if (var1 != null)
        {
            return var1;
        }
        else
        {
            var1 = WorldInfo.get(var0);
            worlds.put(var0, var1);
            Logging.onLoadWorld(var1);
            cli.onLoadWorld(var1);
            return var1;
        }
    }

    public mod_DimensionalAnchors()
    {
        instance = this;
    }

    public boolean clientSideRequired()
    {
        return true;
    }

    public boolean serverSideRequired()
    {
        return false;
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/chunkloader/mod_DimensionalAnchors.info.txt", "version");
    }

    public void load()
    {
        cli = new ChunkLoadInterface125();
        IDAllocator.RegisterBlockID("chunkloader", new IBlockIDCallback()
        {
            public void registerBlock(int var1)
            {
                mod_DimensionalAnchors.this.block = new BlockChunkLoader(var1);
                ModLoader.registerBlock(mod_DimensionalAnchors.this.block, ItemChunkLoader.class);

                if (Config.getBoolean("chunkloader.enableCrafting", true))
                {
                    ModLoader.addRecipe(new ItemStack(mod_DimensionalAnchors.this.block, 1, 0), new Object[] {" G ", "GIG", " G ", 'G', Item.GOLD_INGOT, 'I', Block.IRON_BLOCK});
                }
            }
        });
        ModLoader.registerTileEntity(TileChunkLoader.class, "immibis.chunkloader.TileChunkLoader");
        this.enableClockTicks(true);
        proxy.load();
        SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler()
        {
            public Object getServerGuiElement(int var1, EntityHuman var2, World var3, int var4, int var5, int var6)
            {
                TileEntity var7 = var3.getTileEntity(var4, var5, var6);
                return var1 == 0 ? new ContainerChunkLoader(var2, (TileChunkLoader)var7, false) : (var1 == 1 ? new ContainerChunkLoader(var2, (TileChunkLoader)var7, true) : null);
            }
        });
        OneTwoFiveNetworking.initReceiveClient(new mod_DimensionalAnchors.PacketMap((mod_DimensionalAnchors.PacketMap)null), "immibis.chunkldr");
        OneTwoFiveNetworking.initReceiveServer(new mod_DimensionalAnchors.PacketMap((mod_DimensionalAnchors.PacketMap)null), "immibis.chunkldr");
        Configuration var1;

        try
        {
            Field var2 = Config.class.getDeclaredField("config");
            var2.setAccessible(true);
            var1 = (Configuration)var2.get((Object)null);
        }
        catch (Exception var4)
        {
            throw new RuntimeException(var4);
        }

        if (!var1.categories.containsKey("chunkloader.playerQuotaOverride"))
        {
            var1.categories.put("chunkloader.playerQuotaOverride", new TreeMap());
            Config.save();
        }

        playerQuotaOverride = (Map)var1.categories.get("chunkloader.playerQuotaOverride");
        Fuels.setProperty(var1.getOrCreateProperty("chunkloader.fuels", "general", ""));
        commands.put("getquota", new Command()
        {
            public String getUsage()
            {
                return "/dimanc getquota <username>";
            }
            public void invoke(CommandUser var1, String[] var2, int var3)
            {
                if (var2.length <= var3)
                {
                    var1.send("Not enough arguments.");
                }
                else
                {
                    String var4 = var2[var3++].toLowerCase();
                    var1.send("Player " + var4 + " has used " + mod_DimensionalAnchors.this.getCurQuota(var4) + " of " + mod_DimensionalAnchors.getMaxQuotaString(mod_DimensionalAnchors.this.getMaxQuota(var4)) + " chunks.");
                }
            }
        });
        commands.put("override", new Command()
        {
            public String getUsage()
            {
                return "/dimanc override <username> {<quota>|unlimited|default} - sets a quota override for a specific player";
            }
            public void invoke(CommandUser var1, String[] var2, int var3)
            {
                if (var2.length <= var3)
                {
                    var1.send("Not enough arguments.");
                }
                else
                {
                    String var4 = var2[var3++].toLowerCase();

                    if (var2.length <= var3)
                    {
                        var1.send("Not enough arguments.");
                    }
                    else
                    {
                        String var5 = var2[var3++];

                        if (var5.equalsIgnoreCase("default"))
                        {
                            mod_DimensionalAnchors.playerQuotaOverride.remove(var4);
                            var1.send("\u00a7bOverride for " + var4 + " removed.");
                        }
                        else if (var5.equalsIgnoreCase("unlimited"))
                        {
                            mod_DimensionalAnchors.this.setQuotaOverride(var4, "unlimited");
                            var1.send("\u00a7b" + var4 + " now has unlimited chunks.");
                        }
                        else
                        {
                            try
                            {
                                int var6 = Integer.parseInt(var5);
                                mod_DimensionalAnchors.this.setQuotaOverride(var4, String.valueOf(var6));
                                var1.send("\u00a7b" + var4 + " now has " + var6 + " chunks.");
                            }
                            catch (NumberFormatException var7)
                            {
                                var1.send("\u00a7cSecond argument must be a number, \'default\' or \'unlimited\'.");
                                return;
                            }
                        }

                        EntityHuman var8 = this.getPlayer(var4);

                        if (var8 != null)
                        {
                            SidedProxy.instance.sendChat("\u00a7bYour chunk loading limit was changed by an admin.", var8);
                        }

                        var1.send("\u00a7bNote that existing loaders will not be updated immediately.");
                    }
                }
            }
        });
        requireFuel = Config.getBoolean("chunkloader.useFuel", false);
        allowFuelPiping = Config.getBoolean("chunkloader.allowFuelPiping", false) && requireFuel;

        if (requireFuel)
        {
            Fuels.addCommands();
        }

        String var5 = Config.getString("chunkloader.quotaType", SidedProxy.instance.isDedicatedServer() ? "perplayer" : "unlimited", "general", "Type of quota management to use for chunk loaders. Allowed values: " + Quota.getAllowedTypesString());
        quota = Quota.createInstance(var5);
        showOtherPlayersLoaders = !Config.getBoolean("chunkloader.hideOtherPlayersLoadersInF9", SidedProxy.instance.isDedicatedServer());
        String var6 = Config.getString("chunkloader.logFileName", !SidedProxy.instance.isDedicatedServer() ? "" : "dimensional-anchors.log", "logging", "Name of a file to log creation, deletion and editing of chunk loaders to. Blank for none.").trim();
        String var3 = Config.getString("chunkloader.listFileName", "", "logging", "Name of a file to keep updated with a list of all active chunk loaders. Blank for none.").trim();

        if (!var6.isEmpty())
        {
            Logging.openLog(var6);
        }

        if (!var3.isEmpty())
        {
            Logging.setList(var3);
        }
    }

    public static int parseQuota(String var0) throws NumberFormatException
    {
        return var0.equalsIgnoreCase("unlimited") ? -2 : Integer.parseInt(var0);
    }

    public static String getMaxQuotaString(int var0)
    {
        return var0 == -2 ? "unlimited" : String.valueOf(var0);
    }

    public boolean onTickInGame()
    {
        HashSet var1 = new HashSet();
        Iterator var3 = worlds.entrySet().iterator();

        while (var3.hasNext())
        {
            Entry var2 = (Entry)var3.next();

            if (!this.isWorldCurrent((World)var2.getKey()))
            {
                var1.add((World)var2.getKey());
                cli.onUnloadWorld((WorldInfo)var2.getValue());
                Logging.onUnloadWorld((WorldInfo)var2.getValue());
            }
            else
            {
                ((WorldInfo)var2.getValue()).tick();
            }
        }

        var3 = var1.iterator();

        while (var3.hasNext())
        {
            World var4 = (World)var3.next();
            worlds.remove(var4);
        }

        Logging.flushLog();
        return true;
    }

    public int getCurQuota(String var1)
    {
        int var2 = 0;
        int var5;

        for (Iterator var4 = worlds.entrySet().iterator(); var4.hasNext(); var2 += var5)
        {
            Entry var3 = (Entry)var4.next();
            var5 = ((WorldInfo)var3.getValue()).getCurQuota(var1);
        }

        return var2;
    }

    public int getMaxQuota(String var1)
    {
        var1 = var1.toLowerCase();
        Property var2 = (Property)playerQuotaOverride.get(var1);

        if (var2 != null)
        {
            if (var2.isIntValue())
            {
                return var2.getInt();
            }

            if (var2.value.equals("unlimited"))
            {
                return -2;
            }
        }

        return quota.getMaxQuotaFor(var1);
    }

    public boolean canAddQuota(String var1, int var2)
    {
        if (var2 <= 0)
        {
            return true;
        }
        else
        {
            int var3 = this.getMaxQuota(var1);
            return var3 == -2 ? true : this.getCurQuota(var1) + var2 <= var3;
        }
    }

    public static Iterable allWorlds()
    {
        return worlds.values();
    }

    private void setQuotaOverride(String var1, String var2)
    {
        if (playerQuotaOverride.containsKey(var1))
        {
            ((Property)playerQuotaOverride.get(var1)).value = var2;
        }
        else
        {
            playerQuotaOverride.put(var1, new Property());
            ((Property)playerQuotaOverride.get(var1)).value = var2;
            ((Property)playerQuotaOverride.get(var1)).name = var1;
        }

        Config.save();
    }

    private static class PacketMap implements IPacketMap
    {
        private PacketMap() {}

        public IPacket createPacket(byte var1)
        {
            return (IPacket)(var1 == 0 ? new PacketGUIUpdate("", 0, 0, 0, false, false) : (var1 == 1 ? new PacketShowChunksRequest() : (var1 == 2 ? new PacketShowChunksResponse() : null)));
        }

        PacketMap(mod_DimensionalAnchors.PacketMap var1)
        {
            this();
        }
    }
}
