package immibis.chunkloader.porting;

import forge.IChunkLoadHandler;
import forge.MinecraftForge;
import immibis.chunkloader.mod_DimensionalAnchors;
import java.util.Set;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.Entity;
import net.minecraft.server.World;

public class ChunkLoadInterface125 extends ChunkLoadInterface implements IChunkLoadHandler
{
    public ChunkLoadInterface125()
    {
        MinecraftForge.registerChunkLoadHandler(this);
    }

    public boolean canUpdateEntity(Entity var1)
    {
        return mod_DimensionalAnchors.getWorld(var1.world).isChunkForceLoaded(new ChunkCoordIntPair(var1.ca, var1.cc));
    }

    public boolean canUnloadChunk(Chunk var1)
    {
        return !mod_DimensionalAnchors.getWorld(var1.world).isChunkForceLoaded(var1.k());
    }

    public void addActiveChunks(World var1, Set var2)
    {
        var2.addAll(mod_DimensionalAnchors.getWorld(var1).getLoadedChunks());
    }
}
