package immibis.chunkloader.quota;

import immibis.chunkloader.TileChunkLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Quota
{
    public static final int UNLIMITED = -2;
    private static Map types = new HashMap();

    static
    {
        types.put("unlimited", UnlimitedQuota.class);
        types.put("perplayer", PerPlayerQuota.class);
    }

    public abstract int getMaxQuotaFor(String var1);

    public void onTick(TileChunkLoader var1) {}

    public static String getAllowedTypesString()
    {
        String var0 = "";
        String var1;

        for (Iterator var2 = types.keySet().iterator(); var2.hasNext(); var0 = var0 + var1)
        {
            var1 = (String)var2.next();

            if (!var0.equals(""))
            {
                var0 = var0 + ", ";
            }
        }

        return var0;
    }

    public static Quota createInstance(String var0)
    {
        Class var1 = (Class)types.get(var0);

        if (var1 == null)
        {
            throw new RuntimeException("Invalid quota type: " + var0);
        }
        else
        {
            try
            {
                return (Quota)var1.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception var3)
            {
                throw new RuntimeException(var3);
            }
        }
    }
}
