package immibis.chunkloader;

import immibis.chunkloader.porting.*;
import immibis.chunkloader.quota.Quota;
import immibis.core.Config;

import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;

import java.lang.reflect.Field;
import java.util.logging.Logger;
/* $if jclient$ */
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
/* $if mc > 1.3$ */
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.Mod.ServerStarting;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.asm.SideOnly;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
/* $endif$ */
/* $endif$ */
/* $if jserver$ */
import net.minecraft.server.MinecraftServer;
/* $endif$ */
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
/* $if mc > 1.3$ */
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.common.*;
import net.minecraftforge.common.Property.Type;
/* $endif$ */

import java.util.*;

public class mod_DimensionalAnchors extends PortableBaseMod {
	
	// IDEAS
	// * Let a redstone signal deactivate the chunk loader, removing it from the quota.
	//   This would mean a player would have to reactivate it manually, in most cases,
	//   since the redstone circuit would become unloaded.
	// * Let a *wireless* redstone signal do that.
	// * Chunk loaders that need fuel to run
	
	public static Logger logger = Logger.getLogger("DimensionalAnchors");
	
	// GUI IDs
	public static final int GUI_CHUNKLOADER = 0;
	public static final int GUI_CHUNKLOADER_FUELED = 1;
	
	// Packet IDs
	public static final byte S2C_GUI_UPDATE = 0;
	public static final byte C2S_DATA_REQUEST = 1;
	public static final byte S2C_DATA_RESPONSE = 2;
	
	public static final String CHANNEL =  "immibis.chunkldr";
	public static final int MAX_RADIUS = 4; // 9x9 area
	public static boolean DEBUG = true;
	
	public static Map<World, WorldInfo> worlds = new HashMap<World, WorldInfo>();
	public static boolean showOtherPlayersLoaders = false;
	public static ChunkLoadInterface cli;
	public static Quota quota;
	
	public static boolean requireFuel;
	public static boolean allowFuelPiping;
	
	public static Map<String, Property> playerQuotaOverride;
	
	/* $if joined$ */
	public static @cpw.mods.fml.common.SidedProxy(clientSide="immibis.chunkloader.ClientProxy",serverSide="immibis.chunkloader.BaseProxy") BaseProxy proxy;
	/* $elseif jclient$
	public static BaseProxy proxy = new ClientProxy();
	$else$
	public static BaseProxy proxy = new BaseProxy();
	$endif$ */
	
	// Checks whether the game is still using this World object
	public boolean isWorldCurrent(World w) {
		return SidedProxy.instance.isWorldCurrent(w);
	}
	
	@Override
	public String getPriorities() {
		return "after:mod_ImmibisCore;";
	}
	
	public static WorldInfo getWorld(World w) {
		WorldInfo wi = worlds.get(w);
		if(wi != null)
			return wi;
		wi = WorldInfo.get(w);
		worlds.put(w, wi);
		Logging.onLoadWorld(wi);
		cli.onLoadWorld(wi);
		return wi;
	}
	
	public static mod_DimensionalAnchors instance;
	
	public mod_DimensionalAnchors() {
		instance = this;
	}
	
	public BlockChunkLoader block;

	@Override
	public boolean clientSideRequired() {
		return true;
	}

	@Override
	public boolean serverSideRequired() {
		return false;
	}

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/chunkloader/mod_DimensionalAnchors.info.txt", "version");
	}
	
	public static HashMap<String, Command> commands = new HashMap<String, Command>();
	
	/* $if mc > 1.3$ */
	@ServerStarting
	public void onServerStart(FMLServerStartingEvent event) {
		event.registerServerCommand(new CommandBase() {
			@Override
			public void processCommand(final ICommandSender var1, String[] var2) {
				CommandUser user = new CommandUser() {
					@Override
					public void send(String s) {
						var1.sendChatToPlayer(s);
					}
				};
				
				if(var2.length == 0) {
					var1.sendChatToPlayer("\u00a7cFor command list, use /dimanc help");
					
				} else if(var2[0].equals("help")) {
					if(var2.length < 2) {
						var1.sendChatToPlayer("\u00a7cTry:");
						for(String s : commands.keySet())
							var1.sendChatToPlayer("\u00a7c/dimanc help "+s);
						
					} else {
						if(commands.containsKey(var2[1]))
							commands.get(var2[1]).sendUsage(user, var2);
						else
							var1.sendChatToPlayer("\u00a7cInvalid command. For command list, use /dimanc help");
					}
					
				} else if(!commands.containsKey(var2[0])) {
					var1.sendChatToPlayer("\u00a7cInvalid command. For command list, use /dimanc help");
				} else {
					commands.get(var2[0]).invoke(user, var2, 1);
				}
			}
			
			@Override
			public String getCommandName() {
				return "dimanc";
			}
		});
	}
	/* $endif$ */

	@Override
	public void load() {
		/* $if mc == 1.3.2$ */
		cli = new ChunkLoadInterface132();
		/* $elseif mc == 1.2.5$
		cli = new ChunkLoadInterface125();
		$endif$ */
		
		IDAllocator.RegisterBlockID("chunkloader", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockChunkLoader(id);
				ModLoader.registerBlock(block, ItemChunkLoader.class);
				
				if(Config.getBoolean("chunkloader.enableCrafting", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, 0),
						" G ",
						"GIG",
						" G ",
						'G', Item.ingotGold,
						'I', Block.blockSteel
					);
				}
			}
		});

		ModLoader.registerTileEntity(TileChunkLoader.class, "immibis.chunkloader.TileChunkLoader");
		enableClockTicks(true);
		
		proxy.load();
		
		SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler() {
			
			/* $if jclient$ */
			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				if(ID == GUI_CHUNKLOADER)
					return new GuiAnchor(new ContainerChunkLoader(player, (TileChunkLoader)tile, false));
				if(ID == GUI_CHUNKLOADER_FUELED)
					return new GuiAnchorFueled(new ContainerChunkLoader(player, (TileChunkLoader)tile, true));
				return null;
			}
			/* $endif$ */
			
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				if(ID == GUI_CHUNKLOADER)
					return new ContainerChunkLoader(player, (TileChunkLoader)tile, false);
				if(ID == GUI_CHUNKLOADER_FUELED)
					return new ContainerChunkLoader(player, (TileChunkLoader)tile, true);
				return null;
			}
		});
		
		OneTwoFiveNetworking.initReceiveClient(new PacketMap(), CHANNEL);
		OneTwoFiveNetworking.initReceiveServer(new PacketMap(), CHANNEL);
		
		{
			Configuration cfg = Config.config;
			
			if(!cfg.categories.containsKey("chunkloader.playerQuotaOverride")) {
				cfg.categories.put("chunkloader.playerQuotaOverride", new TreeMap<String, Property>());
				Config.save();
			}
			playerQuotaOverride = cfg.categories.get("chunkloader.playerQuotaOverride");
			/* $if mc > 1.4$ */
			Fuels.setProperty(cfg.get(Configuration.CATEGORY_GENERAL, "chunkloader.fuels", ""));
			/* $else$
			Fuels.setProperty(cfg.getOrCreateProperty("chunkloader.fuels", Configuration.CATEGORY_GENERAL, ""));
			$endif$ */
		}
		
		commands.put("getquota", new Command() {
			@Override public String getUsage() {return "/dimanc getquota <username>";}
			@Override public void invoke(CommandUser cs, String[] args, int nextarg) {
				if(args.length <= nextarg) {
					cs.send("Not enough arguments.");
					return;
				}
				
				String player = args[nextarg++].toLowerCase();
				
				cs.send("Player "+player+" has used "+getCurQuota(player)+" of "+getMaxQuotaString(getMaxQuota(player))+" chunks.");
			}
		});
		
		commands.put("override", new Command() {
			@Override public String getUsage() {return "/dimanc override <username> {<quota>|unlimited|default} - sets a quota override for a specific player";}
			@Override public void invoke(CommandUser cs, String[] args, int nextarg) {
				if(args.length <= nextarg) {
					cs.send("Not enough arguments.");
					return;
				}
				String player = args[nextarg++].toLowerCase();
				if(args.length <= nextarg) {
					cs.send("Not enough arguments.");
					return;
				}
				
				String amtS = args[nextarg++];
				if(amtS.equalsIgnoreCase("default")) {
					playerQuotaOverride.remove(player);
					cs.send("\u00a7bOverride for "+player+" removed.");
				} else if(amtS.equalsIgnoreCase("unlimited")) {
					setQuotaOverride(player, "unlimited");
					cs.send("\u00a7b"+player+" now has unlimited chunks.");
				} else {
					try {
						int amt = Integer.parseInt(amtS);
						setQuotaOverride(player, String.valueOf(amt));
						cs.send("\u00a7b"+player+" now has "+amt+" chunks.");
					} catch(NumberFormatException e) {
						cs.send("\u00a7cSecond argument must be a number, 'default' or 'unlimited'.");
						return;
					}
				}
				
				EntityPlayer pl = getPlayer(player);
				if(pl != null)
					SidedProxy.instance.sendChat("\u00a7bYour chunk loading limit was changed by an admin.", pl);
				
				cs.send("\u00a7bNote that existing loaders will not be updated immediately.");
			}
		});
		
		requireFuel = Config.getBoolean("chunkloader.useFuel", false);
		allowFuelPiping = Config.getBoolean("chunkloader.allowFuelPiping", false) && requireFuel;
		
		if(requireFuel)
			Fuels.addCommands();
				
		String quotaType = Config.getString("chunkloader.quotaType",
				SidedProxy.instance.isDedicatedServer() ? "perplayer" : "unlimited",
				Configuration.CATEGORY_GENERAL,
				"Type of quota management to use for chunk loaders. Allowed values: "+Quota.getAllowedTypesString()
				);
		
		quota = Quota.createInstance(quotaType);
		
		/* $if jserver$ */
		showOtherPlayersLoaders = !Config.getBoolean("chunkloader.hideOtherPlayersLoadersInF9", SidedProxy.instance.isDedicatedServer());
		/* $else$
		showOtherPlayersLoaders = true;
		$endif$ */
		
		String logName = Config.getString("chunkloader.logFileName", !SidedProxy.instance.isDedicatedServer() ? "" : "dimensional-anchors.log", "logging", "Name of a file to log creation, deletion and editing of chunk loaders to. Blank for none.").trim();
		String listName = Config.getString("chunkloader.listFileName", "", "logging", "Name of a file to keep updated with a list of all active chunk loaders. Blank for none.").trim();
		
		if(!logName.isEmpty()) Logging.openLog(logName);
		if(!listName.isEmpty()) Logging.setList(listName);
	}
	
	/* $if jclient && mc < 1.3$
	@Override
	public void keyboardEvent(KeyBinding key) {
		proxy.keyboardEvent(key);
	}
	$endif$ */
	
	public static int parseQuota(String s) throws NumberFormatException {
		if(s.equalsIgnoreCase("unlimited"))
			return Quota.UNLIMITED;
		else
			return Integer.parseInt(s);
	}
	
	public static String getMaxQuotaString(int i) {
		if(i == Quota.UNLIMITED)
			return "unlimited";
		else
			return String.valueOf(i);
	}
	
	@Override
	public boolean onTickInGame() {
		Set<World> toRemove = new HashSet<World>();
		for(Map.Entry<World, WorldInfo> e : worlds.entrySet()) {
			if(e.getValue() == null || !isWorldCurrent(e.getKey())) {
				toRemove.add(e.getKey());
				cli.onUnloadWorld(e.getValue());
				Logging.onUnloadWorld(e.getValue());
			} else {
				e.getValue().tick();
			}
		}
		for(World w : toRemove)
			worlds.remove(w);
		Logging.flushLog();
		return true;
	}

	public int getCurQuota(String player) {
		int r = 0;
		for(Map.Entry<World, WorldInfo> e : worlds.entrySet()) {
			int _this = e.getValue().getCurQuota(player);
			r += _this;
			//System.out.println(e.getKey()+" " + player + " -> " + _this);
		}
		return r;
	}

	public int getMaxQuota(String player) {
		player = player.toLowerCase();
		Property p = playerQuotaOverride.get(player);
		if(p != null)
			if(p.isIntValue())
				return p.getInt();
			else if(p.value.equals("unlimited"))
				return Quota.UNLIMITED;
		return quota.getMaxQuotaFor(player);
	}

	public boolean canAddQuota(String player, int i) {
		if(i <= 0)
			return true;
		int max = getMaxQuota(player);
		if(max == Quota.UNLIMITED)
			return true;
		return getCurQuota(player) + i <= max;
	}

	public static Iterable<WorldInfo> allWorlds() {
		return worlds.values();
	}
	
	private static class PacketMap implements IPacketMap {
		@Override
		public IPacket createPacket(byte id) {
			if(id == S2C_GUI_UPDATE)
				return new PacketGUIUpdate("", 0, 0, 0, false, false);
			if(id == C2S_DATA_REQUEST)
				return new PacketShowChunksRequest();
			if(id == S2C_DATA_RESPONSE)
				return new PacketShowChunksResponse();
			return null;
		}
	}
	
	private void setQuotaOverride(String key, String value) {
		if(playerQuotaOverride.containsKey(key)) {
			playerQuotaOverride.get(key).value = value;
		} else {
			playerQuotaOverride.put(key, new Property());
			playerQuotaOverride.get(key).value = value;
			/* $if mc > 1.3$ */
			playerQuotaOverride.get(key).setName(key);
			/* $else$
			playerQuotaOverride.get(key).name = key;
			$endif$ */
		}
		Config.save();
	}
}
