package immibis.chunkloader.porting;

/* $if mc >= 1.3.2$ */

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

import cpw.mods.fml.common.Loader;

import immibis.chunkloader.mod_DimensionalAnchors;
import immibis.chunkloader.WorldInfo;
import immibis.chunkloader.mod_DimensionalAnchors;
import immibis.core.Config;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeChunkManager.LoadingCallback;
import net.minecraftforge.common.ForgeChunkManager.Ticket;
import net.minecraftforge.common.ForgeChunkManager.Type;

public class ChunkLoadInterface132 extends ChunkLoadInterface implements LoadingCallback {
	
	private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
		Field f = clazz.getDeclaredField(name);
		f.setAccessible(true);
		return f;
	}
	
	@SuppressWarnings("unchecked")
	public ChunkLoadInterface132() {
		boolean bypassForgeLimits = Config.getBoolean("chunkloader.bypassForgeChunkLimits", true);
		
		if(bypassForgeLimits) {
			try {
				boolean overridesEnabled = getField(ForgeChunkManager.class, "overridesEnabled").getBoolean(null);
				
				Map<String, Integer> ticketConstraints = (Map<String, Integer>)getField(ForgeChunkManager.class, "ticketConstraints").get(null);
				Map<String, Integer> chunkConstraints = (Map<String, Integer>)getField(ForgeChunkManager.class, "chunkConstraints").get(null);
				
				if(!overridesEnabled) {
					ticketConstraints.clear();
					chunkConstraints.clear();
					getField(ForgeChunkManager.class, "overridesEnabled").set(null, true);
				}
				
				String modid = Loader.instance().getModObjectList().inverse().get(mod_DimensionalAnchors.instance).getModId();
				
				ticketConstraints.put(modid, Integer.MAX_VALUE);
				chunkConstraints.put(modid, Integer.MAX_VALUE);
				
				mod_DimensionalAnchors.logger.info("Bypassed Forge chunk limits");
				
			} catch(Exception e) {
				throw new RuntimeException(e);
			}
		}
		
		ForgeChunkManager.setForcedChunkLoadingCallback(mod_DimensionalAnchors.instance, this);
	}
	
	@Override
	public void ticketsLoaded(List<Ticket> tickets, World world) {
		for(Ticket t : tickets)
			ForgeChunkManager.releaseTicket(t);
	}
	
	@Override
	public void onLoadWorld(WorldInfo w) {
		mod_DimensionalAnchors.logger.fine("Requesting chunk loading ticket for "+w.getName());
		w.cliData = ForgeChunkManager.requestTicket(mod_DimensionalAnchors.instance, w.world, Type.NORMAL);
	}
	
	@Override
	public void onUnloadWorld(WorldInfo w) {
		mod_DimensionalAnchors.logger.fine("Releasing chunk loading ticket for "+w.getName());
		ForgeChunkManager.releaseTicket((Ticket)w.cliData);
	}
	
	@Override
	public void addChunk(WorldInfo w, ChunkCoordIntPair ccip) {
		ForgeChunkManager.forceChunk((Ticket)w.cliData, ccip);
	}
	
	@Override
	public void removeChunk(WorldInfo w, ChunkCoordIntPair ccip) {
		ForgeChunkManager.unforceChunk((Ticket)w.cliData, ccip);
	}
}

/* $endif$ */