package immibis.chunkloader;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import immibis.core.net.AbstractContainerSyncPacket;

public class PacketGUIUpdate extends AbstractContainerSyncPacket {
	
	public String owner;
	public int curQuota, maxQuota, radius;
	public boolean amIOp, isServerOwned;

	public PacketGUIUpdate(String owner, int curQuota, int maxQuota, int radius, boolean amIOp, boolean isServerOwned) {
		this.owner = owner;
		this.curQuota = curQuota;
		this.maxQuota = maxQuota;
		this.radius = radius;
		this.amIOp = amIOp;
		this.isServerOwned = isServerOwned;
	}

	@Override
	public byte getID() {
		return DimensionalAnchors.S2C_GUI_UPDATE;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		owner = in.readUTF();
		curQuota = in.readInt();
		maxQuota = in.readInt();
		radius = in.readInt();
		amIOp = in.readBoolean();
		isServerOwned = in.readBoolean();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeUTF(owner);
		out.writeInt(curQuota);
		out.writeInt(maxQuota);
		out.writeInt(radius);
		out.writeBoolean(amIOp);
		out.writeBoolean(isServerOwned);
	}
}
